/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.csv.converters;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.thucydides.core.csv.converters.BigDecimalTypeConverter;
import net.thucydides.core.csv.converters.IntegerTypeConverter;
import net.thucydides.core.csv.converters.StringTypeConverter;
import net.thucydides.core.csv.converters.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeConverters {
    private static final List<TypeConverter> DEFAULT_TYPE_CONVERTERS = ImmutableList.of((Object)new StringTypeConverter(), (Object)new IntegerTypeConverter(), (Object)new BigDecimalTypeConverter());

    public static List<TypeConverter> getDefaultTypeConverters() {
        return DEFAULT_TYPE_CONVERTERS;
    }

    public static TypeConverter getTypeConverterFor(Class<?> type) {
        for (TypeConverter typeConverter : DEFAULT_TYPE_CONVERTERS) {
            if (!typeConverter.appliesTo(type)) continue;
            return typeConverter;
        }
        throw new IllegalArgumentException("No applicable type converter found for " + type);
    }
}

