/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.util;

import java.io.File;
import java.io.IOException;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedTemporaryFolder
extends TemporaryFolder {
    private static final Logger logger = LoggerFactory.getLogger(ExtendedTemporaryFolder.class);

    protected static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public File newFolder() throws IOException {
        if (ExtendedTemporaryFolder.isWindows()) {
            try {
                return super.newFolder();
            }
            catch (IOException e) {
                logger.error("Error when invoke newFolder(): {}", (Throwable)e);
                return super.newFolder("junit");
            }
        }
        return super.newFolder();
    }

    public File newFile(String fileName) throws IOException {
        if (ExtendedTemporaryFolder.isWindows()) {
            File file = new File(this.getRoot(), fileName);
            try {
                file.setWritable(true);
                file.setReadable(true);
                file.createNewFile();
            }
            catch (IOException e) {
                logger.error("Error when invoke newFile(fileName): {}", (Object)e.toString());
            }
            return file;
        }
        return super.newFile(fileName);
    }
}

