/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core;

import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ThucydidesSystemProperty {
    DRIVER("webdriver.driver"),
    BASE_URL("webdriver.base.url"),
    REMOTE_URL("webdriver.remote.url"),
    REMOTE_BROWSER("webdriver.remote."),
    PROJECT_KEY("thucydides.project.key"),
    THUCYDIDES_HOME("thucydides.home"),
    THUCYDIDES_DATABASE_JDBC_OPTIONS("thucydides.database.jdbc.options"),
    RECORD_STATISTICS("thucydides.record.statistics"),
    REPORT_RESOURCE_PATH("thucydides.report.resources"),
    OUTPUT_DIRECTORY("thucydides.outputDirectory"),
    ONLY_SAVE_FAILING_SCREENSHOTS("thucydides.only.save.failing.screenshots"),
    VERBOSE_SCREENSHOTS("thucydides.verbose.screenshots"),
    SHOW_STEP_DETAILS("thucydides.reports.show.step.details"),
    RESTART_BROWSER_FREQUENCY("thucydides.restart.browser.frequency"),
    STEP_DELAY("thucycides.step.delay"),
    ELEMENT_TIMEOUT("thucydides.timeout"),
    ASSUME_UNTRUSTED_CERTIFICATE_ISSUER("refuse.untrusted.certificates"),
    UNIQUE_BROWSER("thucydides.use.unique.browser"),
    ESTIMATED_AVERAGE_STEP_COUNT("thucydides.estimated.average.step.count"),
    ISSUE_TRACKER_URL("thucydides.issue.tracker.url"),
    NATIVE_EVENTS("thucydides.native.events"),
    JIRA_URL("jira.url"),
    JIRA_PROJECT("jira.project"),
    JIRA_USERNAME("jira.username"),
    JIRA_PASSWORD("jira.password"),
    HISTORY_BASE_DIRECTORY("thucydides.history"),
    SNAPSHOT_HEIGHT("thucydides.browser.height"),
    SNAPSHOT_WIDTH("thucydides.browser.width"),
    RESIZED_WIDTH("thucydides.resized.image.width"),
    PUBLIC_URL("thucydides.public.url"),
    ACTIVATE_FIREBUGS("thucydides.activate.firebugs"),
    ACTIVTE_HIGHLIGHTING("thucydides.activate.highlighting"),
    BATCH_COUNT("thucydides.batch.count"),
    BATCH_SIZE("thucydides.batch.size"),
    BATCH_NUMBER("thucydides.batch.number"),
    PROXY_URL("thucydides.proxy.http"),
    PROXY_PORT("thucydides.proxy.http_port"),
    TIMEOUTS_IMPLICIT_WAIT("webdriver.timeouts.implicitywait"),
    EXTENSION_PACKAGES("thucydides.ext.packages"),
    CHROME_SWITCHES("chrome.switches"),
    JQUERY_INTEGRATION("thucydides.jquery.integration"),
    SAUCELABS_TARGET_PLATFORM("saucelabs.target.platform"),
    SAUCELABS_DRIVER_VERSION("saucelabs.driver.version"),
    SAUCELABS_TEST_NAME("saucelabs.test.name"),
    SAUCELABS_URL("saucelabs.url"),
    SAUCELABS_ACCESS_KEY("saucelabs.access.key"),
    SAUCELABS_USER_ID("saucelabs.user.id"),
    SAUCELABS_IMPLICIT_TIMEOUT("saucelabs.implicit.timeout"),
    FILE_IO_RETRY_TIMEOUT("thucydides.file.io.retry.timeout"),
    LOGGING("thucydides.logging"),
    THUCYDIDES_TEST_ROOT("thucydides.test.root"),
    CAPABILITY_TYPES("thucydides.capability.types"),
    DATA_DIRECTORY("thucydides.data.dir"),
    STATISTICS_DRIVER("thucydides.statistics.driver_class"),
    STATISTICS_URL("thucydides.statistics.url"),
    STATISTICS_USERNAME("thucydides.statistics.username"),
    STATISTICS_PASSWORD("thucydides.statistics.password"),
    STATISTICS_DIALECT("thucydides.statistics.dialect");

    private String propertyName;
    public static final int DEFAULT_HEIGHT = 700;
    public static final int DEFAULT_WIDTH = 960;

    private ThucydidesSystemProperty(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String toString() {
        return this.propertyName;
    }

    public String from(EnvironmentVariables environmentVariables) {
        return environmentVariables.getProperty(this.getPropertyName());
    }

    public String from(EnvironmentVariables environmentVariables, String defaultValue) {
        String value = environmentVariables.getProperty(this.getPropertyName());
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        return value;
    }

    public boolean isDefinedIn(EnvironmentVariables environmentVariables) {
        return StringUtils.isNotEmpty((CharSequence)this.from(environmentVariables));
    }
}

