/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import net.thucydides.core.annotations.WhenPageOpens;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.pages.MatchingPageExpressions;
import net.thucydides.core.pages.PageUrls;
import net.thucydides.core.pages.RenderedPageObjectView;
import net.thucydides.core.pages.SystemClock;
import net.thucydides.core.pages.UnableToInvokeWhenPageOpensMethods;
import net.thucydides.core.pages.WebElementFacade;
import net.thucydides.core.pages.WrongPageError;
import net.thucydides.core.pages.components.Dropdown;
import net.thucydides.core.pages.components.FileToUpload;
import net.thucydides.core.pages.jquery.JQueryEnabledPage;
import net.thucydides.core.scheduling.FluentWaitWithRefresh;
import net.thucydides.core.scheduling.NormalFluentWait;
import net.thucydides.core.scheduling.ThucydidesFluentWait;
import net.thucydides.core.steps.StepDelayer;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.javascript.JavascriptExecutorFacade;
import net.thucydides.core.webdriver.javascript.JavascriptSupport;
import net.thucydides.core.webelements.Checkbox;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.Sleeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PageObject {
    private static final int WAIT_FOR_ELEMENT_PAUSE_LENGTH = 250;
    private static final int ONE_SECOND = 1000;
    private long waitForTimeoutInMilliseconds = 5000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PageObject.class);
    private static final long WAIT_FOR_TIMEOUT = 30000L;
    private WebDriver driver;
    private MatchingPageExpressions matchingPageExpressions;
    private RenderedPageObjectView renderedView;
    private PageUrls pageUrls;
    private SystemClock clock;
    private final Sleeper sleeper;
    private final Clock webdriverClock;
    private final JavascriptExecutorFacade javascriptExecutorFacade;
    private boolean jquerySupportActivated = false;

    public PageObject(WebDriver driver, int ajaxTimeout) {
        this.driver = driver;
        this.waitForTimeoutInMilliseconds = ajaxTimeout;
        this.webdriverClock = new org.openqa.selenium.support.ui.SystemClock();
        this.clock = (SystemClock)Injectors.getInjector().getInstance(SystemClock.class);
        this.sleeper = Sleeper.SYSTEM_SLEEPER;
        this.javascriptExecutorFacade = new JavascriptExecutorFacade(driver);
        this.setupPageUrls();
        int ajaxTimeoutInSeconds = this.ajaxTimeoutInSecondsWithAtLeast1Second(ajaxTimeout);
        WebDriverFactory.initElementsWithAjaxSupport(this, driver, ajaxTimeoutInSeconds);
    }

    protected int ajaxTimeoutInSecondsWithAtLeast1Second(int ajaxTimeout) {
        if (ajaxTimeout > 1000) {
            return ajaxTimeout / 1000;
        }
        return 1;
    }

    public PageObject(WebDriver driver) {
        this.driver = driver;
        this.waitForTimeoutInMilliseconds = 30000L;
        this.webdriverClock = new org.openqa.selenium.support.ui.SystemClock();
        this.clock = (SystemClock)Injectors.getInjector().getInstance(SystemClock.class);
        this.sleeper = Sleeper.SYSTEM_SLEEPER;
        this.javascriptExecutorFacade = new JavascriptExecutorFacade(driver);
        this.setupPageUrls();
        WebDriverFactory.initElementsWithAjaxSupport(this, driver);
    }

    public FileToUpload upload(String filename) {
        return new FileToUpload(filename);
    }

    private void setupPageUrls() {
        this.setPageUrls(new PageUrls(this));
    }

    public void setPageUrls(PageUrls pageUrls) {
        this.pageUrls = pageUrls;
    }

    public void setWaitForTimeout(long waitForTimeoutInMilliseconds) {
        this.waitForTimeoutInMilliseconds = waitForTimeoutInMilliseconds;
        this.getRenderedView().setWaitForTimeoutInMilliseconds(this.waitForTimeoutInMilliseconds);
    }

    protected RenderedPageObjectView getRenderedView() {
        if (this.renderedView == null) {
            this.renderedView = new RenderedPageObjectView(this.driver, this.waitForTimeoutInMilliseconds);
        }
        return this.renderedView;
    }

    protected SystemClock getClock() {
        return this.clock;
    }

    private MatchingPageExpressions getMatchingPageExpressions() {
        if (this.matchingPageExpressions == null) {
            this.matchingPageExpressions = new MatchingPageExpressions(this);
        }
        return this.matchingPageExpressions;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public String getTitle() {
        return this.driver.getTitle();
    }

    protected boolean matchesAnyUrl() {
        return this.thereAreNoPatternsDefined();
    }

    public final boolean compatibleWithUrl(String currentUrl) {
        if (this.thereAreNoPatternsDefined()) {
            return true;
        }
        return this.matchUrlAgainstEachPattern(currentUrl);
    }

    private boolean matchUrlAgainstEachPattern(String currentUrl) {
        return this.getMatchingPageExpressions().matchUrlAgainstEachPattern(currentUrl);
    }

    private boolean thereAreNoPatternsDefined() {
        return this.getMatchingPageExpressions().isEmpty();
    }

    public PageObject waitForRenderedElements(By byElementCriteria) {
        this.getRenderedView().waitFor(byElementCriteria);
        return this;
    }

    public PageObject waitFor(String xpathOrCssSelector) {
        return this.waitForRenderedElements(this.xpathOrCssSelector(xpathOrCssSelector));
    }

    public PageObject waitFor(ExpectedCondition expectedCondition) {
        this.getRenderedView().waitFor(expectedCondition);
        return this;
    }

    public PageObject waitForRenderedElementsToBePresent(By byElementCriteria) {
        this.getRenderedView().waitForPresenceOf(byElementCriteria);
        return this;
    }

    public PageObject waitForPresenceOf(String xpathOrCssSelector) {
        return this.waitForRenderedElementsToBePresent(this.xpathOrCssSelector(xpathOrCssSelector));
    }

    public PageObject waitForRenderedElementsToDisappear(By byElementCriteria) {
        this.getRenderedView().waitForElementsToDisappear(byElementCriteria);
        return this;
    }

    public PageObject waitForAbsenceOf(String xpathOrCssSelector) {
        return this.waitForRenderedElementsToDisappear(this.xpathOrCssSelector(xpathOrCssSelector));
    }

    public PageObject waitForTextToAppear(String expectedText) {
        this.getRenderedView().waitForText(expectedText);
        return this;
    }

    public PageObject waitForTitleToAppear(String expectedTitle) {
        this.getRenderedView().waitForTitle(expectedTitle);
        return this;
    }

    public PageObject waitForTitleToDisappear(String expectedTitle) {
        this.getRenderedView().waitForTitleToDisappear(expectedTitle);
        return this;
    }

    public PageObject waitForTextToAppear(WebElement element, String expectedText) {
        this.getRenderedView().waitForText(element, expectedText);
        return this;
    }

    public PageObject waitForTextToDisappear(WebElement element, String expectedText) {
        this.waitForCondition().until(this.elementDoesNotContain(element, expectedText));
        return this;
    }

    private ExpectedCondition<Boolean> elementDoesNotContain(final WebElement element, final String expectedText) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return !element.getText().contains(expectedText);
            }
        };
    }

    public PageObject waitForTextToDisappear(String expectedText) {
        return this.waitForTextToDisappear(expectedText, this.waitForTimeoutInMilliseconds);
    }

    public PageObject waitForTextToDisappear(String expectedText, long timeout) {
        this.getRenderedView().waitForTextToDisappear(expectedText, timeout);
        return this;
    }

    public PageObject waitForAnyTextToAppear(String ... expectedText) {
        this.getRenderedView().waitForAnyTextToAppear(expectedText);
        return this;
    }

    public PageObject waitForAnyTextToAppear(WebElement element, String ... expectedText) {
        this.getRenderedView().waitForAnyTextToAppear(element, expectedText);
        return this;
    }

    public PageObject waitForAllTextToAppear(String ... expectedTexts) {
        this.getRenderedView().waitForAllTextToAppear(expectedTexts);
        return this;
    }

    public PageObject waitForAnyRenderedElementOf(By ... expectedElements) {
        this.getRenderedView().waitForAnyRenderedElementOf(expectedElements);
        return this;
    }

    protected void waitABit(long timeInMilliseconds) {
        this.getClock().pauseFor(timeInMilliseconds);
    }

    public StepDelayer.WaitForBuilder waitFor(int duration) {
        return new StepDelayer(this.clock).waitFor(duration);
    }

    public List<WebElement> thenReturnElementList(By byListCriteria) {
        return this.driver.findElements(byListCriteria);
    }

    public void shouldContainText(String textValue) {
        if (!this.containsText(textValue)) {
            String errorMessage = String.format("The text '%s' was not found in the page", textValue);
            throw new NoSuchElementException(errorMessage);
        }
    }

    public void shouldContainAllText(String ... textValues) {
        if (!this.containsAllText(textValues)) {
            String errorMessage = String.format("One of the text elements in '%s' was not found in the page", textValues);
            throw new NoSuchElementException(errorMessage);
        }
    }

    @Deprecated
    public boolean containsTextInElement(WebElement webElement, String textValue) {
        return this.element(webElement).containsText(textValue);
    }

    @Deprecated
    public void shouldContainTextInElement(WebElement webElement, String textValue) {
        this.element(webElement).shouldContainText(textValue);
    }

    @Deprecated
    public void shouldNotContainTextInElement(WebElement webElement, String textValue) {
        this.element(webElement).shouldNotContainText(textValue);
    }

    public void typeInto(WebElement field, String value) {
        this.element(field).type(value);
    }

    public FieldEntry enter(String value) {
        return new FieldEntry(value);
    }

    public void selectFromDropdown(WebElement dropdown, String visibleLabel) {
        Dropdown.forWebElement(dropdown).select(visibleLabel);
        this.notifyScreenChange();
    }

    public void selectMultipleItemsFromDropdown(WebElement dropdown, String ... selectedLabels) {
        Dropdown.forWebElement(dropdown).selectMultipleItems(selectedLabels);
        this.notifyScreenChange();
    }

    public Set<String> getSelectedOptionLabelsFrom(WebElement dropdown) {
        return Dropdown.forWebElement(dropdown).getSelectedOptionLabels();
    }

    public Set<String> getSelectedOptionValuesFrom(WebElement dropdown) {
        return Dropdown.forWebElement(dropdown).getSelectedOptionValues();
    }

    public String getSelectedValueFrom(WebElement dropdown) {
        return Dropdown.forWebElement(dropdown).getSelectedValue();
    }

    public String getSelectedLabelFrom(WebElement dropdown) {
        return Dropdown.forWebElement(dropdown).getSelectedLabel();
    }

    public void setCheckbox(WebElement field, boolean value) {
        Checkbox checkbox = new Checkbox(field);
        checkbox.setChecked(value);
        this.notifyScreenChange();
    }

    public boolean containsText(String textValue) {
        return this.getRenderedView().containsText(textValue);
    }

    public boolean containsAllText(String ... textValues) {
        for (String textValue : textValues) {
            if (this.getRenderedView().containsText(textValue)) continue;
            return false;
        }
        return true;
    }

    public void shouldBeVisible(WebElement field) {
        this.element(field).shouldBeVisible();
    }

    public void shouldBeVisible(By byCriteria) {
        WebElement element = this.getDriver().findElement(byCriteria);
        this.shouldBeVisible(element);
    }

    public void shouldNotBeVisible(WebElement field) {
        try {
            this.element(field).shouldNotBeVisible();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void shouldNotBeVisible(By byCriteria) {
        try {
            WebElement element = this.getDriver().findElement(byCriteria);
            this.shouldNotBeVisible(element);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public String updateUrlWithBaseUrlIfDefined(String startingUrl) {
        String baseUrl = this.pageUrls.getBaseUrl();
        if (baseUrl != null && !StringUtils.isEmpty((CharSequence)baseUrl)) {
            return this.replaceHost(startingUrl, baseUrl);
        }
        return startingUrl;
    }

    private String replaceHost(String starting, String base) {
        String updatedUrl = starting;
        try {
            URL startingUrl = new URL(starting);
            URL baseUrl = new URL(base);
            String startingHostComponent = this.hostComponentFrom(startingUrl.getProtocol(), startingUrl.getHost(), startingUrl.getPort());
            String baseHostComponent = this.hostComponentFrom(baseUrl.getProtocol(), baseUrl.getHost(), baseUrl.getPort());
            updatedUrl = starting.replaceFirst(startingHostComponent, baseHostComponent);
        }
        catch (MalformedURLException e) {
            LOGGER.error("Failed to analyse default page URL: Starting URL: {}, Base URL: {}", (Object)starting, (Object)base);
            LOGGER.error("URL analysis failed with exception:", (Throwable)e);
        }
        return updatedUrl;
    }

    private String hostComponentFrom(String protocol, String host, int port) {
        StringBuffer hostComponent = new StringBuffer(protocol);
        hostComponent.append("://");
        hostComponent.append(host);
        if (port > 0) {
            hostComponent.append(":");
            hostComponent.append(port);
        }
        return hostComponent.toString();
    }

    public final void open(String ... parameterValues) {
        String startingUrl = this.pageUrls.getStartingUrl(parameterValues);
        LOGGER.debug("Opening page at url {}", (Object)startingUrl);
        this.openPageAtUrl(startingUrl);
        this.initializePage();
        LOGGER.debug("Page opened");
    }

    public final void open(String urlTemplateName, String[] parameterValues) {
        String startingUrl = this.pageUrls.getNamedUrl(urlTemplateName, parameterValues);
        LOGGER.debug("Opening page at url {}", (Object)startingUrl);
        this.openPageAtUrl(startingUrl);
        this.initializePage();
        LOGGER.debug("Page opened");
    }

    public final void open() {
        String startingUrl = this.updateUrlWithBaseUrlIfDefined(this.pageUrls.getStartingUrl());
        this.openPageAtUrl(startingUrl);
        this.initializePage();
    }

    private void initializePage() {
        this.checkUrlPatterns();
        this.addJQuerySupport();
        this.callWhenPageOpensMethods();
    }

    private <T extends PageObject> void checkUrlPatterns() {
        String currentUrl;
        if (!this.matchesAnyUrl() && !this.compatibleWithUrl(currentUrl = this.getDriver().getCurrentUrl())) {
            this.thisIsNotThePageYourLookingFor();
        }
    }

    private void thisIsNotThePageYourLookingFor() {
        String errorDetails = "This is not the page you're looking for:\nI was looking for a page compatible with " + this.getClass() + "\n" + "I was at the URL " + this.getDriver().getCurrentUrl();
        throw new WrongPageError(errorDetails);
    }

    public final void openAt(String startingUrl) {
        this.openPageAtUrl(startingUrl);
        this.callWhenPageOpensMethods();
    }

    public void callWhenPageOpensMethods() {
        for (Method annotatedMethod : this.methodsAnnotatedWithWhenPageOpens()) {
            try {
                annotatedMethod.setAccessible(true);
                annotatedMethod.invoke((Object)this, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Could not execute @WhenPageOpens annotated method: " + e.getMessage());
                throw new UnableToInvokeWhenPageOpensMethods("Could not execute @WhenPageOpens annotated method: " + e.getMessage(), e);
            }
        }
    }

    private List<Method> methodsAnnotatedWithWhenPageOpens() {
        Method[] methods = this.getClass().getDeclaredMethods();
        ArrayList<Method> annotatedMethods = new ArrayList<Method>();
        for (Method method : methods) {
            if (method.getAnnotation(WhenPageOpens.class) == null) continue;
            if (method.getParameterTypes().length == 0) {
                annotatedMethods.add(method);
                continue;
            }
            throw new UnableToInvokeWhenPageOpensMethods("Could not execute @WhenPageOpens annotated method: WhenPageOpens method cannot have parameters: " + method);
        }
        return annotatedMethods;
    }

    public static String[] withParameters(String ... parameterValues) {
        return parameterValues;
    }

    private void openPageAtUrl(String startingUrl) {
        this.getDriver().get(startingUrl);
        if (JavascriptSupport.javascriptIsSupportedIn(this.getDriver())) {
            this.addJQuerySupport();
        }
    }

    public void clickOn(WebElement webElement) {
        this.element(webElement).click();
    }

    public Boolean isElementVisible(By byCriteria) {
        return this.getRenderedView().elementIsDisplayed(byCriteria);
    }

    public void setDefaultBaseUrl(String defaultBaseUrl) {
        this.pageUrls.overrideDefaultBaseUrl(defaultBaseUrl);
    }

    public boolean hasFocus(WebElement webElement) {
        return this.element(webElement).hasFocus();
    }

    public void blurActiveElement() {
        this.getJavascriptExecutorFacade().executeScript("document.activeElement.blur();");
    }

    protected JavascriptExecutorFacade getJavascriptExecutorFacade() {
        return this.javascriptExecutorFacade;
    }

    public WebElementFacade element(WebElement webElement) {
        return new WebElementFacade(this.driver, webElement, this.waitForTimeoutInMilliseconds);
    }

    public WebElementFacade $(WebElement webElement) {
        return this.element(webElement);
    }

    public WebElementFacade $(String xpathOrCssSelector) {
        return this.element(xpathOrCssSelector);
    }

    public WebElementFacade element(By bySelector) {
        WebElement webElement = this.getDriver().findElement(bySelector);
        return new WebElementFacade(this.driver, webElement, this.waitForTimeoutInMilliseconds);
    }

    public WebElementFacade find(By selector) {
        return this.element(selector);
    }

    public List<WebElementFacade> findAll(By bySelector) {
        List matchingWebElements = this.driver.findElements(bySelector);
        return Lambda.convert((Object)matchingWebElements, this.toWebElementFacades());
    }

    private Converter<WebElement, WebElementFacade> toWebElementFacades() {
        return new Converter<WebElement, WebElementFacade>(){

            public WebElementFacade convert(WebElement from) {
                return PageObject.this.element(from);
            }
        };
    }

    public WebElementFacade element(String xpathOrCssSelector) {
        return this.element(this.xpathOrCssSelector(xpathOrCssSelector));
    }

    private By xpathOrCssSelector(String xpathOrCssSelector) {
        if (PageObject.isXPath(xpathOrCssSelector)) {
            return By.xpath((String)xpathOrCssSelector);
        }
        return By.cssSelector((String)xpathOrCssSelector);
    }

    public WebElementFacade findBy(String xpathOrCssSelector) {
        return this.element(xpathOrCssSelector);
    }

    public static boolean isXPath(String xpathExpression) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            xpath.compile(xpathExpression);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Object evaluateJavascript(String script) {
        this.addJQuerySupport();
        JavascriptExecutorFacade js = new JavascriptExecutorFacade(this.driver);
        return js.executeScript(script);
    }

    public Object evaluateJavascript(String script, Object ... params) {
        this.addJQuerySupport();
        JavascriptExecutorFacade js = new JavascriptExecutorFacade(this.driver);
        return js.executeScript(script, params);
    }

    public void addJQuerySupport() {
        if (this.pageIsLoaded()) {
            JQueryEnabledPage jQueryEnabledPage = JQueryEnabledPage.withDriver(this.getDriver());
            if (!jQueryEnabledPage.isJQueryEnabled()) {
                jQueryEnabledPage.injectJQuery();
                jQueryEnabledPage.injectJQueryPlugins();
            }
            this.jquerySupportActivated = true;
        }
    }

    private boolean pageIsLoaded() {
        try {
            return this.getDriver().getCurrentUrl() != null;
        }
        catch (WebDriverException e) {
            return false;
        }
    }

    private boolean driverIsEnabled() {
        if (WebDriverFacade.class.isAssignableFrom(this.getDriver().getClass())) {
            WebDriverFacade driverFacade = (WebDriverFacade)this.getDriver();
            return driverFacade.isEnabled();
        }
        return true;
    }

    public ThucydidesFluentWait<WebDriver> waitForWithRefresh() {
        return new FluentWaitWithRefresh<WebDriver>(this.driver, this.webdriverClock, this.sleeper).withTimeout(this.waitForTimeoutInMilliseconds, TimeUnit.MILLISECONDS).pollingEvery(250L, TimeUnit.MILLISECONDS).ignoring(NoSuchElementException.class, NoSuchFrameException.class);
    }

    public ThucydidesFluentWait<WebDriver> waitForCondition() {
        return new NormalFluentWait<WebDriver>(this.driver, this.webdriverClock, this.sleeper).withTimeout(this.waitForTimeoutInMilliseconds, TimeUnit.MILLISECONDS).pollingEvery(250L, TimeUnit.MILLISECONDS).ignoring(NoSuchElementException.class, NoSuchFrameException.class);
    }

    public Alert getAlert() {
        return this.driver.switchTo().alert();
    }

    public Actions withAction() {
        WebDriver proxiedDriver = ((WebDriverFacade)this.getDriver()).getProxiedDriver();
        return new Actions(proxiedDriver);
    }

    private void notifyScreenChange() {
        StepEventBus.getEventBus().notifyScreenChange();
    }

    public class FieldEntry {
        private final String value;

        public FieldEntry(String value) {
            this.value = value;
        }

        public void into(WebElement field) {
            PageObject.this.element(field).type(this.value);
        }

        public void intoField(By bySelector) {
            WebElement field = PageObject.this.getDriver().findElement(bySelector);
            PageObject.this.element(field).type(this.value);
        }
    }
}

