/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.util;

import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemEnvironmentVariables
implements EnvironmentVariables {
    @Override
    public String getValue(String name) {
        return this.getValue(name, null);
    }

    @Override
    public String getValue(Enum<?> property) {
        return this.getValue(property.toString());
    }

    @Override
    public String getValue(String name, String defaultValue) {
        String value = System.getenv(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public String getValue(Enum<?> property, String defaultValue) {
        return this.getValue(property.toString(), defaultValue);
    }

    @Override
    public Integer getPropertyAsInteger(String property, Integer defaultValue) {
        String value = System.getProperty(property);
        if (value != null) {
            return Integer.valueOf(value);
        }
        return defaultValue;
    }

    @Override
    public Integer getPropertyAsInteger(Enum<?> property, Integer defaultValue) {
        return this.getPropertyAsInteger(property.toString(), defaultValue);
    }

    @Override
    public Boolean getPropertyAsBoolean(String name, boolean defaultValue) {
        if (System.getProperty(name) == null) {
            return defaultValue;
        }
        if (StringUtils.isBlank((CharSequence)System.getProperty(name))) {
            return true;
        }
        return Boolean.parseBoolean(System.getProperty(name, "false"));
    }

    @Override
    public Boolean getPropertyAsBoolean(Enum<?> property, boolean defaultValue) {
        return this.getPropertyAsBoolean(property.toString(), defaultValue);
    }

    @Override
    public String getProperty(String name) {
        return System.getProperty(name);
    }

    @Override
    public String getProperty(Enum<?> property) {
        return this.getProperty(property.toString());
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        return System.getProperty(name, defaultValue);
    }

    @Override
    public String getProperty(Enum<?> property, String defaultValue) {
        return this.getProperty(property.toString(), defaultValue);
    }

    @Override
    public void setProperty(String name, String value) {
        System.setProperty(name, value);
    }

    @Override
    public void clearProperty(String name) {
        System.clearProperty(name);
    }
}

