/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations;

import com.google.common.base.Optional;
import net.thucydides.core.annotations.ManagedWebDriverAnnotatedField;
import org.openqa.selenium.WebDriver;

public final class TestCaseAnnotations {
    private final Object testCase;

    private TestCaseAnnotations(Object testCase) {
        this.testCase = testCase;
    }

    public static TestCaseAnnotations forTestCase(Object testCase) {
        return new TestCaseAnnotations(testCase);
    }

    public void injectDriver(WebDriver driver) {
        Optional<ManagedWebDriverAnnotatedField> webDriverField = ManagedWebDriverAnnotatedField.findOptionalAnnotatedField(this.testCase.getClass());
        if (webDriverField.isPresent()) {
            ((ManagedWebDriverAnnotatedField)webDriverField.get()).setValue(this.testCase, driver);
        }
    }

    public static boolean supportsWebTests(Class clazz) {
        return ManagedWebDriverAnnotatedField.hasManagedWebdriverField(clazz);
    }

    public boolean isUniqueSession() {
        ManagedWebDriverAnnotatedField webDriverField = ManagedWebDriverAnnotatedField.findFirstAnnotatedField(this.testCase.getClass());
        return webDriverField.isUniqueSession();
    }
}

