/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class FilePathParser {
    private final EnvironmentVariables environmentVariables;

    public FilePathParser(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public String getInstanciatedPath(String path) {
        String testDataSource = this.operatingSystemLocalized(path);
        testDataSource = this.injectVariable(testDataSource, "HOME", System.getProperty("user.home"));
        testDataSource = this.injectVariable(testDataSource, "USERDIR", System.getProperty("user.dir"));
        testDataSource = this.injectVariable(testDataSource, "DATADIR", ThucydidesSystemProperty.DATA_DIRECTORY.from(this.environmentVariables));
        return testDataSource;
    }

    private String operatingSystemLocalized(String testDataSource) {
        return StringUtils.replace((String)testDataSource, (String)this.getFileSeparatorToReplace(), (String)this.getFileSeparator());
    }

    private String injectVariable(String path, String variable, String directory) {
        if (StringUtils.isNotEmpty((CharSequence)directory)) {
            path = StringUtils.replace((String)path, (String)("$" + variable), (String)directory);
            return StringUtils.replace((String)path, (String)("${" + variable + "}"), (String)directory);
        }
        return path;
    }

    protected String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    protected String getFileSeparatorToReplace() {
        return this.getFileSeparator().equals("/") ? "\\" : "/";
    }
}

