/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.matchers.dates;

import net.thucydides.core.matchers.dates.DateMatcherFormatter;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DateTimeIsBetweenMatcher
extends TypeSafeMatcher<DateTime> {
    private final DateTime startDate;
    private final DateTime endDate;

    public DateTimeIsBetweenMatcher(DateTime startDate, DateTime endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public boolean matchesSafely(DateTime provided) {
        return !(!provided.isEqual((ReadableInstant)this.startDate) && !provided.isAfter((ReadableInstant)this.startDate) || !provided.isEqual((ReadableInstant)this.endDate) && !provided.isBefore((ReadableInstant)this.endDate));
    }

    public void describeTo(Description description) {
        description.appendText("a date that is between ");
        description.appendText(DateMatcherFormatter.formatted(this.startDate));
        description.appendText(" and ");
        description.appendText(DateMatcherFormatter.formatted(this.endDate));
    }
}

