/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import net.thucydides.core.model.DataTableRow;
import net.thucydides.core.model.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTable {
    private final List<String> headers;
    private final List<DataTableRow> rows;
    private final boolean predefinedRows;
    private AtomicInteger currentRow = new AtomicInteger(0);
    private static final List<DataTableRow> NO_ROWS = Lists.newArrayList();

    private DataTable(List<String> headers, List<DataTableRow> rows) {
        this.headers = headers;
        this.rows = new CopyOnWriteArrayList<DataTableRow>(rows);
        this.predefinedRows = !rows.isEmpty();
    }

    public static DataTableBuilder withHeaders(List<String> headers) {
        return new DataTableBuilder(headers);
    }

    public List<String> getHeaders() {
        return ImmutableList.copyOf(this.headers);
    }

    public List<DataTableRow> getRows() {
        return ImmutableList.copyOf(this.rows);
    }

    public RowValueAccessor row(int rowNumber) {
        return new RowValueAccessor(this, rowNumber);
    }

    public RowValueAccessor nextRow() {
        return new RowValueAccessor(this, this.nextRowNumber());
    }

    public boolean atLastRow() {
        return this.rows.isEmpty() || this.currentRow.get() == this.rows.size() - 1;
    }

    public RowValueAccessor currentRow() {
        return new RowValueAccessor(this, this.currentRowNumber());
    }

    private int nextRowNumber() {
        return this.currentRow.incrementAndGet();
    }

    private int currentRowNumber() {
        return this.currentRow.intValue();
    }

    public void addRow(Map<String, String> data) {
        DataTableRow newRow = new DataTableRow((List<String>)ImmutableList.copyOf(data.values()));
        this.rows.add(newRow);
        this.currentRow.set(this.rows.size() - 1);
    }

    public boolean hasPredefinedRows() {
        return this.predefinedRows;
    }

    public class RowValueAccessor {
        private final DataTable dataTable;
        private final int rowNumber;

        public RowValueAccessor(DataTable dataTable2, int rowNumber) {
            this.dataTable = dataTable2;
            this.rowNumber = rowNumber;
        }

        public void hasResult(TestResult result) {
            ((DataTableRow)this.dataTable.rows.get(this.rowNumber)).updateResult(result);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DataTableBuilder {
        final List<String> headers;
        final List<DataTableRow> rows;

        public DataTableBuilder(List<String> headers) {
            this(headers, NO_ROWS);
        }

        public DataTableBuilder(List<String> headers, List<DataTableRow> rows) {
            this.headers = headers;
            this.rows = rows;
        }

        public DataTable build() {
            return new DataTable(this.headers, this.rows);
        }

        public DataTableBuilder andRows(List<List<String>> rows) {
            return new DataTableBuilder(this.headers, Lambda.convert(rows, this.toDataTableRows()));
        }

        public DataTableBuilder andRowData(List<DataTableRow> rows) {
            return new DataTableBuilder(this.headers, rows);
        }

        public DataTableBuilder andMappedRows(List<Map<String, String>> mappedRows) {
            ArrayList rowData = Lists.newArrayList();
            for (Map<String, String> mappedRow : mappedRows) {
                rowData.add(this.rowDataFrom(mappedRow));
            }
            return new DataTableBuilder(this.headers, Lambda.convert((Object)rowData, this.toDataTableRows()));
        }

        private Converter<List<String>, DataTableRow> toDataTableRows() {
            return new Converter<List<String>, DataTableRow>(){

                public DataTableRow convert(List<String> cellValues) {
                    return new DataTableRow(cellValues);
                }
            };
        }

        private List<String> rowDataFrom(Map<String, String> mappedRow) {
            ArrayList rowData = Lists.newArrayList();
            for (String header : this.headers) {
                rowData.add(mappedRow.get(header));
            }
            return rowData;
        }
    }
}

