/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTableRow {
    private final List<String> cellValues;
    private TestResult result;

    public DataTableRow(List<String> cellValues) {
        this.cellValues = ImmutableList.copyOf(cellValues);
        this.result = TestResult.UNDEFINED;
    }

    public List<String> getValues() {
        return ImmutableList.copyOf(this.cellValues);
    }

    public TestResult getResult() {
        return this.result;
    }

    public void setResult(TestResult result) {
        this.result = result;
    }

    public void updateResult(TestResult newResult) {
        if (newResult == TestResult.UNDEFINED) {
            this.setResult(newResult);
        } else {
            TestResultList testResults = TestResultList.of(this.result, newResult);
            this.setResult(testResults.getOverallResult());
        }
    }
}

