/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.screenshots;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.jhlabs.image.BoxBlurFilter;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.thucydides.core.digest.Digest;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.screenshots.BlurLevel;
import net.thucydides.core.screenshots.QueuedScreenshot;
import net.thucydides.core.screenshots.ScreenshotProcessor;
import net.thucydides.core.screenshots.ScreenshotSequence;
import net.thucydides.core.webdriver.WebDriverFacade;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Photographer {
    private static final int MESSAGE_DIGEST_MASK = 255;
    private static final int PNG_SUFFIX_LENGTH = ".png".length();
    private final WebDriver driver;
    private final File targetDirectory;
    private final ScreenshotSequence screenshotSequence;
    private Optional<BlurLevel> blurLevel;
    private final Logger logger = LoggerFactory.getLogger(Photographer.class);
    private ScreenshotProcessor screenshotProcessor;
    private static final ScreenshotSequence DEFAULT_SCREENSHOT_SEQUENCE = new ScreenshotSequence();

    protected Logger getLogger() {
        return this.logger;
    }

    public Photographer(WebDriver driver, File targetDirectory) {
        this(driver, targetDirectory, (ScreenshotProcessor)Injectors.getInjector().getInstance(ScreenshotProcessor.class), (Optional<BlurLevel>)Optional.absent());
    }

    public Photographer(WebDriver driver, File targetDirectory, Optional<BlurLevel> blurLevel) {
        this(driver, targetDirectory, (ScreenshotProcessor)Injectors.getInjector().getInstance(ScreenshotProcessor.class), blurLevel);
    }

    public Photographer(WebDriver driver, File targetDirectory, ScreenshotProcessor screenshotProcessor) {
        this(driver, targetDirectory, screenshotProcessor, (Optional<BlurLevel>)Optional.absent());
    }

    public Photographer(WebDriver driver, File targetDirectory, ScreenshotProcessor screenshotProcessor, Optional<BlurLevel> blurLevel) {
        Preconditions.checkNotNull((Object)targetDirectory);
        Preconditions.checkNotNull((Object)screenshotProcessor);
        this.driver = driver;
        this.targetDirectory = targetDirectory;
        this.screenshotProcessor = screenshotProcessor;
        this.screenshotSequence = DEFAULT_SCREENSHOT_SEQUENCE;
        this.blurLevel = blurLevel;
    }

    protected long nextScreenshotNumber() {
        return this.screenshotSequence.next();
    }

    private String nextScreenshotName(String prefix) {
        long nextScreenshotNumber = this.nextScreenshotNumber();
        return "screenshot-" + Digest.ofTextValue(prefix) + nextScreenshotNumber + ".png";
    }

    public Optional<File> takeScreenshot(String prefix) {
        if (this.driverCanTakeSnapshots()) {
            try {
                File screenshotFile = null;
                Object capturedScreenshot = ((TakesScreenshot)this.driver).getScreenshotAs(OutputType.FILE);
                if (this.isAFile(capturedScreenshot)) {
                    screenshotFile = (File)capturedScreenshot;
                } else if (this.isByteArray(capturedScreenshot)) {
                    screenshotFile = this.saveScreenshotData((byte[])capturedScreenshot);
                }
                if (screenshotFile != null && this.blurLevel.isPresent()) {
                    screenshotFile = this.blur(screenshotFile);
                }
                if (screenshotFile != null) {
                    File savedScreenshot = this.targetScreenshot(prefix);
                    this.screenshotProcessor.queueScreenshot(new QueuedScreenshot(screenshotFile, savedScreenshot));
                    if (!this.blurLevel.isPresent()) {
                        this.savePageSourceFor(savedScreenshot.getAbsolutePath());
                    }
                    return Optional.of((Object)savedScreenshot);
                }
            }
            catch (Throwable e) {
                this.getLogger().warn("Failed to write screenshot (possibly an out of memory error): " + e.getMessage());
            }
        }
        return Optional.absent();
    }

    protected File blur(File srcFile) throws Exception {
        BufferedImage srcImage = ImageIO.read(srcFile);
        BufferedImage destImage = this.deepCopy(srcImage);
        BoxBlurFilter boxBlurFilter = new BoxBlurFilter();
        boxBlurFilter.setRadius(((BlurLevel)((Object)this.blurLevel.get())).getRadius());
        boxBlurFilter.setIterations(3);
        destImage = boxBlurFilter.filter(srcImage, destImage);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)destImage, "png", outStream);
        return this.saveScreenshotData(outStream.toByteArray());
    }

    private BufferedImage deepCopy(BufferedImage srcImage) {
        ColorModel cm = srcImage.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = srcImage.copyData(null);
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }

    private File saveScreenshotData(byte[] capturedScreenshot) throws IOException {
        String screenshotTempFileName = "screenshot_" + UUID.randomUUID();
        File screenshotFile = new File(FileUtils.getTempDirectory(), screenshotTempFileName);
        byte[] screenshotData = capturedScreenshot;
        screenshotFile.deleteOnExit();
        if (screenshotData.length > 0) {
            FileUtils.writeByteArrayToFile((File)screenshotFile, (byte[])screenshotData);
        } else {
            FileUtils.touch((File)screenshotFile);
        }
        return screenshotFile;
    }

    private boolean isAFile(Object screenshot) {
        return screenshot instanceof File;
    }

    private boolean isByteArray(Object screenshot) {
        return screenshot instanceof byte[];
    }

    private File targetScreenshot(String prefix) {
        this.targetDirectory.mkdirs();
        return new File(this.targetDirectory, this.nextScreenshotName(prefix));
    }

    protected boolean driverCanTakeSnapshots() {
        if (this.driver == null) {
            return false;
        }
        if (this.driver instanceof WebDriverFacade) {
            return ((WebDriverFacade)this.driver).canTakeScreenshots() && ((WebDriverFacade)this.driver).getProxiedDriver() != null;
        }
        return TakesScreenshot.class.isAssignableFrom(this.driver.getClass());
    }

    private void savePageSourceFor(String screenshotFile) throws IOException {
        try {
            WebDriver webdriver = this.driver;
            String pageSource = webdriver.getPageSource();
            File savedSource = new File(this.sourceCodeFileFor(screenshotFile));
            FileUtils.writeStringToFile((File)savedSource, (String)pageSource);
        }
        catch (WebDriverException e) {
            this.getLogger().warn("Failed to save screen source code", (Throwable)e);
        }
    }

    private String sourceCodeFileFor(String screenshotFile) {
        String rootFilename = screenshotFile.substring(0, screenshotFile.length() - PNG_SUFFIX_LENGTH);
        return rootFilename + ".html";
    }

    public File getMatchingSourceCodeFor(File screenshot) {
        if (screenshot != null) {
            return new File(this.sourceCodeFileFor(screenshot.getAbsolutePath()));
        }
        return null;
    }

    public void setScreenshotProcessor(ScreenshotProcessor screenshotProcessor) {
        this.screenshotProcessor = screenshotProcessor;
    }

    protected ScreenshotProcessor getScreenshotProcessor() {
        return this.screenshotProcessor;
    }
}

