/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.screenshots;

import com.google.common.base.Optional;
import java.lang.reflect.Method;
import net.thucydides.core.annotations.BlurScreenshots;
import net.thucydides.core.screenshots.BlurLevel;
import org.apache.commons.lang3.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScreenshotBlurCheck {
    public Optional<BlurLevel> blurLevel() {
        return this.fromAnnotation();
    }

    private Optional<BlurLevel> fromAnnotation() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : stackTrace = new Throwable().getStackTrace()) {
            Method callingMethod = null;
            try {
                callingMethod = this.findMethodIn(stackTraceElement);
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
            if (callingMethod == null || callingMethod.getAnnotation(BlurScreenshots.class) == null) continue;
            return Optional.of((Object)((Object)BlurLevel.valueOf(callingMethod.getAnnotation(BlurScreenshots.class).value().toUpperCase())));
        }
        return Optional.absent();
    }

    private Method findMethodIn(StackTraceElement stackTraceElement) throws ClassNotFoundException {
        if (this.allowedClassName(stackTraceElement.getClassName())) {
            Method[] methods;
            Class<?> callingClass = Class.forName(stackTraceElement.getClassName());
            for (Method method : methods = (Method[])ArrayUtils.addAll((Object[])callingClass.getDeclaredMethods(), (Object[])callingClass.getMethods())) {
                if (!stackTraceElement.getMethodName().equals(method.getName())) continue;
                return method;
            }
        }
        return null;
    }

    private boolean allowedClassName(String className) {
        return !className.startsWith("sun.") && !className.startsWith("java.");
    }
}

