/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.Listeners;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.webdriver.Configuration;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThucydidesListeners {
    private Configuration systemConfiguration;
    private BaseStepListener baseStepListener;
    private List<StepListener> stepListeners;

    public ThucydidesListeners(Configuration systemConfiguration) {
        this.systemConfiguration = systemConfiguration;
        File outputDirectory = this.getSystemConfiguration().getOutputDirectory();
        this.baseStepListener = Listeners.getBaseStepListener().withOutputDirectory(outputDirectory);
        this.stepListeners = ImmutableList.of((Object)this.baseStepListener, (Object)Listeners.getLoggingListener(), (Object)Listeners.getStatisticsListener());
        StepEventBus.getEventBus().dropAllListeners();
        this.registerListeners();
    }

    private void registerListeners() {
        StepEventBus.getEventBus().registerListener(this.baseStepListener);
        for (StepListener listener : this.stepListeners) {
            if (listener == null) continue;
            StepEventBus.getEventBus().registerListener(listener);
        }
    }

    public ThucydidesListeners withDriver(WebDriver driver) {
        this.baseStepListener.setDriver(driver);
        return this;
    }

    public BaseStepListener getBaseStepListener() {
        return this.baseStepListener;
    }

    public List<TestOutcome> getResults() {
        return ImmutableList.copyOf(this.baseStepListener.getTestOutcomes());
    }

    protected Configuration getSystemConfiguration() {
        if (this.systemConfiguration == null) {
            this.systemConfiguration = (Configuration)Injectors.getInjector().getInstance(Configuration.class);
        }
        return this.systemConfiguration;
    }
}

