/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.thucydides.core.webdriver.WebDriverFacade;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebdriverInstances {
    private final Map<String, WebDriver> driverMap = new HashMap<String, WebDriver>();
    private String currentDriver;

    public WebDriver getCurrentDriver() {
        if (this.driverMap.containsKey(this.currentDriver)) {
            return this.driverMap.get(this.currentDriver);
        }
        return null;
    }

    public String getCurrentDriverName() {
        return this.currentDriver;
    }

    public WebDriver closeCurrentDriver() {
        WebDriver closedDriver = null;
        if (this.getCurrentDriver() != null) {
            closedDriver = this.getCurrentDriver();
            this.closeAndQuite(closedDriver);
            this.driverMap.remove(this.currentDriver);
            this.currentDriver = null;
        }
        return closedDriver;
    }

    private void closeAndQuite(WebDriver driver) {
        driver.close();
        driver.quit();
    }

    public void resetCurrentDriver() {
        WebDriver driver;
        if (this.getCurrentDriver() != null && WebDriverFacade.class.isAssignableFrom((driver = this.getCurrentDriver()).getClass())) {
            ((WebDriverFacade)driver).reset();
        }
    }

    public boolean driverIsRegisteredFor(String driverName) {
        return this.driverMap.containsKey(this.normalized(driverName));
    }

    public WebDriver useDriver(String driverName) {
        this.currentDriver = this.normalized(driverName);
        return this.driverMap.get(this.currentDriver);
    }

    public Set<WebDriver> closeAllDrivers() {
        Collection<WebDriver> openDrivers = this.driverMap.values();
        HashSet<WebDriver> closedDrivers = new HashSet<WebDriver>(openDrivers);
        for (WebDriver driver : openDrivers) {
            this.closeAndQuite(driver);
        }
        this.driverMap.clear();
        this.currentDriver = null;
        return closedDrivers;
    }

    public int getActiveWebdriverCount() {
        return this.driverMap.size();
    }

    public InstanceRegistration registerDriverCalled(String driverName) {
        return new InstanceRegistration(this.normalized(driverName));
    }

    private String normalized(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return "firefox";
        }
        return name.toLowerCase();
    }

    public final class InstanceRegistration {
        private final String driverName;

        public InstanceRegistration(String driverName) {
            this.driverName = WebdriverInstances.this.normalized(driverName);
        }

        public void forDriver(WebDriver driver) {
            WebdriverInstances.this.driverMap.put(WebdriverInstances.this.normalized(this.driverName), driver);
            WebdriverInstances.this.currentDriver = WebdriverInstances.this.normalized(this.driverName);
        }
    }
}

