/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.gwt.pages;

import java.io.File;
import net.thucydides.core.pages.PageObject;
import net.thucydides.gwt.widgets.FileToUpload;
import net.thucydides.gwt.widgets.GwtButton;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public abstract class GwtPageObject
extends PageObject {
    public GwtPageObject(WebDriver driver) {
        super(driver);
    }

    public GwtButton getButtonLabelled(String label) {
        String buttonXPath = String.format("//button[contains(.,'%s')]", label);
        WebElement button = this.getDriver().findElement(By.xpath((String)buttonXPath));
        return new GwtButton(label, button);
    }

    public GwtButton findButton(By byIdentifer) {
        WebElement button = this.getDriver().findElement(byIdentifer);
        return new GwtButton(button.getText(), button);
    }

    public FileToUpload uploadFileFromResourcePath(String filename) {
        ClassLoader cldr = Thread.currentThread().getContextClassLoader();
        String uploadPath = cldr.getResource(filename).getFile();
        return new FileToUpload(uploadPath);
    }

    public FileToUpload uploadFileFromFileSystem(String filename) {
        File fileToUpload = new File(filename);
        String uploadPath = fileToUpload.getAbsolutePath();
        return new FileToUpload(uploadPath);
    }
}

