/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.gwt.widgets;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.WebElement;

public class FileToUpload {
    private final String filename;
    private final Pattern windowsPath = Pattern.compile("/[A-Z]:.*");

    public FileToUpload(String filename) {
        this.filename = filename;
    }

    public void to(WebElement uploadFileField) {
        uploadFileField.sendKeys(new CharSequence[]{this.osSpecificPathOf(this.filename)});
    }

    private String osSpecificPathOf(String fileToUpload) {
        if (this.isAWindows(fileToUpload)) {
            return this.windowsNative(fileToUpload);
        }
        return fileToUpload;
    }

    private String windowsNative(String fileToUpload) {
        String bareFilename = fileToUpload.substring(1);
        return StringUtils.replace((String)bareFilename, (String)"/", (String)"\\");
    }

    private boolean isAWindows(String fileToUpload) {
        Matcher matcher = this.windowsPath.matcher(fileToUpload);
        return matcher.matches();
    }
}

