/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.gwt.widgets;

import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwtButton {
    private static final int WAIT_FOR_ELEMENT_PAUSE_LENGTH = 50;
    private static final int TIMEOUT = 60000;
    private long waitForTimeout = 60000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(GwtButton.class);
    private final String label;
    private final WebElement button;

    public GwtButton(String label, WebElement button) {
        this.label = label;
        this.button = button;
    }

    public GwtButton(WebElement button) {
        this.button = button;
        this.label = button.getText();
    }

    public void setWaitForTimeout(long waitForTimeout) {
        this.waitForTimeout = waitForTimeout;
    }

    public String getLabel() {
        return this.label;
    }

    public Boolean isEnabled() {
        return this.button.isEnabled();
    }

    public Boolean isVisible() {
        return this.button.isDisplayed();
    }

    public Boolean isDisabled() {
        return !this.button.isEnabled();
    }

    public void click() {
        this.button.click();
    }

    public GwtButton waitUntilEnabled() {
        long end = System.currentTimeMillis() + this.waitForTimeout;
        while (System.currentTimeMillis() < end && !this.isEnabled().booleanValue()) {
            this.waitABit(50L);
        }
        if (this.isDisabled().booleanValue()) {
            throw new ElementNotVisibleException("The '" + this.label + "' button should be enabled but was not.");
        }
        return this;
    }

    protected void waitABit(long timeInMilliseconds) {
        try {
            Thread.sleep(timeInMilliseconds);
        }
        catch (InterruptedException e) {
            LOGGER.error("Wait interrupted", (Throwable)e);
        }
    }
}

