package net.thucydides.junit.annotations;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;

/**
 * Annotation that marks a WebDriver field as one that is managed by the Test Runner.
 * The Thucydides Test Runner will instantiate this WebDriver before the tests start,
 * and close it once they have all finished.
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface Title {
    String value();
}
