/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.runners;

import net.thucydides.junit.internals.ManagedWebDriverAnnotatedField;
import net.thucydides.junit.internals.PagesAnnotatedField;
import net.thucydides.junit.internals.StepsAnnotatedField;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestCaseAnnotations {
    private TestCaseAnnotations() {
    }

    public static void checkThatTestCaseIsCorrectlyAnnotated(Class<?> testCase) {
        TestCaseAnnotations.checkThatManagedFieldIsDefinedIn(testCase);
        TestCaseAnnotations.checkThatStepsFieldIsDefinedIn(testCase);
        TestCaseAnnotations.checkThatPagesFieldIsDefinedIn(testCase);
    }

    private static void checkThatManagedFieldIsDefinedIn(Class<?> testCase) {
        ManagedWebDriverAnnotatedField.findFirstAnnotatedField(testCase);
    }

    private static void checkThatStepsFieldIsDefinedIn(Class<?> testCase) {
        StepsAnnotatedField.findMandatoryAnnotatedFields(testCase);
    }

    private static void checkThatPagesFieldIsDefinedIn(Class<?> testCase) {
        PagesAnnotatedField.findFirstAnnotatedField(testCase);
    }

    public static void injectDriverInto(Object testCase, WebDriver driver) {
        ManagedWebDriverAnnotatedField webDriverField = ManagedWebDriverAnnotatedField.findFirstAnnotatedField(testCase.getClass());
        webDriverField.setValue(testCase, driver);
    }
}

