/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.runners;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.model.AcceptanceTestRun;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebdriverManager;
import net.thucydides.junit.runners.TestCaseAnnotations;
import net.thucydides.junit.steps.ScenarioStepListener;
import net.thucydides.junit.steps.StepAnnotations;
import net.thucydides.junit.steps.StepFactory;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThucydidesRunner
extends BlockJUnit4ClassRunner {
    private WebDriverFactory webDriverFactory;
    private StepFactory stepFactory;
    private Pages pages;
    private WebdriverManager webdriverManager;
    private ScenarioStepListener stepListener;
    private Configuration configuration;
    private List<AcceptanceTestReporter> subscribedReporters = new ArrayList<AcceptanceTestReporter>();

    public ScenarioStepListener getStepListener() {
        if (this.stepListener == null) {
            this.stepListener = new ScenarioStepListener((TakesScreenshot)this.getDriver(), this.getConfiguration());
        }
        return this.stepListener;
    }

    public ThucydidesRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.checkRequestedDriverType();
        TestCaseAnnotations.checkThatTestCaseIsCorrectlyAnnotated(klass);
        this.webDriverFactory = new WebDriverFactory();
    }

    protected Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new Configuration();
        }
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    private void checkRequestedDriverType() {
        this.getConfiguration().getDriverType();
    }

    public void setWebDriverFactory(WebDriverFactory webDriverFactory) {
        this.webDriverFactory = webDriverFactory;
    }

    public File getOutputDirectory() {
        return this.getConfiguration().getOutputDirectory();
    }

    public void subscribeReporter(AcceptanceTestReporter reporter) {
        reporter.setOutputDirectory(this.getConfiguration().getOutputDirectory());
        this.subscribedReporters.add(reporter);
    }

    public void run(RunNotifier notifier) {
        this.webdriverManager = new WebdriverManager(this.webDriverFactory, this.getConfiguration());
        this.setupDefaultReporters();
        super.run(notifier);
        this.webdriverManager.closeDriver();
        this.generateReportsFor(this.getStepListener().getTestRunResults());
        this.notifyFailures();
    }

    private void notifyFailures() {
        if (this.stepFactory != null) {
            this.stepFactory.notifyStepFailures();
        }
    }

    private void setupDefaultReporters() {
        this.subscribedReporters.addAll(this.getConfiguration().getDefaultReporters());
    }

    private void generateReportsFor(List<AcceptanceTestRun> testRunResults) {
        for (AcceptanceTestReporter reporter : this.getSubscribedReporters()) {
            for (AcceptanceTestRun testRunResult : testRunResults) {
                this.generateReportFor(testRunResult, reporter);
            }
        }
    }

    private void generateReportFor(AcceptanceTestRun acceptanceTestRun, AcceptanceTestReporter reporter) {
        try {
            reporter.setOutputDirectory(this.getConfiguration().getOutputDirectory());
            reporter.generateReportFor(acceptanceTestRun);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to generate reports using " + reporter, e);
        }
    }

    public List<AcceptanceTestReporter> getSubscribedReporters() {
        return ImmutableList.copyOf(this.subscribedReporters);
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        this.injectDriverInto(test);
        this.injectAnnotatedPagesObjectInto(test);
        this.injectScenarioStepsInto(test);
        this.stepFactory.addListener(this.getStepListener());
        this.notifyTestStart(method);
        return super.methodInvoker(method, test);
    }

    private void notifyTestStart(FrameworkMethod method) {
        try {
            this.getStepListener().testRunStarted(Description.createTestDescription(method.getMethod().getDeclaringClass(), (String)method.getName()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void injectDriverInto(Object testCase) {
        TestCaseAnnotations.injectDriverInto(testCase, this.getDriver());
    }

    protected void injectScenarioStepsInto(Object testCase) {
        this.stepFactory = new StepFactory(this.pages);
        StepAnnotations.injectScenarioStepsInto(testCase, this.stepFactory);
    }

    protected void injectAnnotatedPagesObjectInto(Object testCase) {
        this.pages = new Pages(this.getDriver());
        StepAnnotations.injectAnnotatedPagesObjectInto(testCase, this.pages);
    }

    protected WebDriver getDriver() {
        return this.webdriverManager.getWebdriver();
    }

    public List<AcceptanceTestRun> getAcceptanceTestRuns() {
        return this.getStepListener().getTestRunResults();
    }
}

