/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.steps;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.annotations.Step;
import net.thucydides.core.annotations.StepDescription;
import net.thucydides.core.annotations.StepGroup;
import net.thucydides.core.util.NameConverter;
import net.thucydides.junit.annotations.TestsRequirement;
import net.thucydides.junit.annotations.TestsRequirements;
import net.thucydides.junit.annotations.Title;
import org.junit.runner.Description;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedDescription {
    private final Description description;

    public AnnotatedDescription(Description description) {
        this.description = description;
    }

    public List<String> getAnnotatedRequirements() {
        ArrayList<String> requirements = new ArrayList<String>();
        try {
            Method testMethod = this.getTestMethod();
            this.addRequirementFrom(requirements, testMethod);
            this.addMultipleRequirementsFrom(requirements, testMethod);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return requirements;
    }

    private void addMultipleRequirementsFrom(List<String> requirements, Method testMethod) {
        TestsRequirements testRequirements = testMethod.getAnnotation(TestsRequirements.class);
        if (testRequirements != null) {
            for (String requirement : testRequirements.value()) {
                requirements.add(requirement);
            }
        }
    }

    private void addRequirementFrom(List<String> requirements, Method testMethod) {
        TestsRequirement testsRequirement = testMethod.getAnnotation(TestsRequirement.class);
        if (testsRequirement != null) {
            requirements.add(testsRequirement.value());
        }
    }

    public String getAnnotatedDescription() {
        String annotatedDescription = null;
        try {
            Method testMethod = this.getTestMethod();
            annotatedDescription = this.getNameFromTestDescriptionAnnotation(testMethod);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return annotatedDescription;
    }

    private String getNameFromTestDescriptionAnnotation(Method testMethod) {
        StepDescription stepDescription = testMethod.getAnnotation(StepDescription.class);
        String annotatedDescription = null;
        if (stepDescription != null) {
            annotatedDescription = stepDescription.value();
        }
        return annotatedDescription;
    }

    public Method getTestMethod() throws NoSuchMethodException {
        return this.methodCalled(this.withNoArguments(this.description.getMethodName()), this.getTestClass());
    }

    private String withNoArguments(String methodName) {
        int firstSpace = methodName.indexOf(":");
        if (firstSpace > 0) {
            return methodName.substring(0, firstSpace);
        }
        return methodName;
    }

    private Class<?> getTestClass() {
        return this.description.getTestClass();
    }

    private Method methodCalled(String methodName, Class<?> testClass) {
        Method[] methods;
        for (Method method : methods = testClass.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        throw new IllegalArgumentException("No test method called " + methodName + " was found in " + testClass);
    }

    public String getAnnotatedTitle() {
        try {
            Method testMethod = this.getTestMethod();
            Title title = testMethod.getAnnotation(Title.class);
            if (title != null) {
                return title.value();
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getAnnotatedStepName() {
        try {
            Method testMethod = this.getTestMethod();
            Step step = testMethod.getAnnotation(Step.class);
            if (step != null && step.value().length() > 0) {
                return step.value();
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getName() {
        AnnotatedDescription testDescription = new AnnotatedDescription(this.description);
        String annotatedTestName = this.getAnnotatedStepName();
        String annotatedDescription = testDescription.getAnnotatedDescription();
        if (annotatedTestName != null) {
            return annotatedTestName;
        }
        if (annotatedDescription != null) {
            return annotatedDescription;
        }
        return this.getHumanizedTestName();
    }

    public String getTitle() {
        AnnotatedDescription testDescription = new AnnotatedDescription(this.description);
        String annotationTitle = testDescription.getAnnotatedTitle();
        if (annotationTitle != null) {
            return NameConverter.humanize((String)annotationTitle);
        }
        String testMethodName = this.description.getMethodName();
        return NameConverter.humanize((String)testMethodName);
    }

    private String getHumanizedTestName() {
        String testName = this.description.getMethodName();
        return NameConverter.humanize((String)testName);
    }

    public boolean isAGroup() {
        try {
            Method testMethod = this.getTestMethod();
            StepGroup testGroup = testMethod.getAnnotation(StepGroup.class);
            if (testGroup != null) {
                return true;
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return false;
    }

    public String getGroupName() {
        try {
            Method testMethod = this.getTestMethod();
            StepGroup testGroup = testMethod.getAnnotation(StepGroup.class);
            if (testGroup != null) {
                return testGroup.value();
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }
}

