/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.steps;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.model.AcceptanceTestRun;
import net.thucydides.core.model.ConcreteTestStep;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.model.UserStory;
import net.thucydides.core.screenshots.Photographer;
import net.thucydides.core.util.NameConverter;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.junit.annotations.UserStoryCode;
import net.thucydides.junit.internals.TestStatus;
import net.thucydides.junit.steps.AnnotatedDescription;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.openqa.selenium.TakesScreenshot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScenarioStepListener
extends RunListener {
    private final List<AcceptanceTestRun> acceptanceTestRuns = new ArrayList<AcceptanceTestRun>();
    private final Photographer photographer;
    private AcceptanceTestRun currentAcceptanceTestRun;
    private ConcreteTestStep currentTestStep;

    public ScenarioStepListener(TakesScreenshot driver, Configuration configuration) {
        TakesScreenshot screenshotCapableDriver = driver;
        this.photographer = new Photographer(screenshotCapableDriver, configuration.getOutputDirectory());
    }

    public List<AcceptanceTestRun> getTestRunResults() {
        return this.acceptanceTestRuns;
    }

    private void getCurrentTestStepFrom(Description description) {
        if (this.currentTestStep == null) {
            this.currentTestStep = new ConcreteTestStep();
        }
    }

    private void recordCurrentTestStep(Description description) {
        this.getCurrentTestStepFrom(description);
        this.addAnyTestedRequirementsIn(description);
        AnnotatedDescription testDescription = new AnnotatedDescription(description);
        String testName = testDescription.getName();
        this.currentTestStep.setDescription(testName);
        this.currentTestStep.recordDuration();
        this.getCurrentAcceptanceTestRun().recordStep((TestStep)this.currentTestStep);
        this.getCurrentAcceptanceTestRun().recordDuration();
        this.currentTestStep = null;
    }

    private void addAnyTestedRequirementsIn(Description description) {
        AnnotatedDescription testDescription = new AnnotatedDescription(description);
        List<String> requirements = testDescription.getAnnotatedRequirements();
        if (!requirements.isEmpty()) {
            for (String requirement : requirements) {
                this.currentTestStep.testsRequirement(requirement);
            }
        }
    }

    private File grabScreenshotFileFor(String testName) throws IOException {
        String snapshotName = NameConverter.underscore((String)testName);
        File screenshot = null;
        try {
            screenshot = this.getPhotographer().takeScreenshot(snapshotName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return screenshot;
    }

    public Photographer getPhotographer() {
        return this.photographer;
    }

    protected AcceptanceTestRun getCurrentAcceptanceTestRun() {
        if (this.currentAcceptanceTestRun == null) {
            this.currentAcceptanceTestRun = new AcceptanceTestRun();
        }
        return this.currentAcceptanceTestRun;
    }

    protected AcceptanceTestRun getNewCurrentAcceptanceTestRun() {
        this.currentAcceptanceTestRun = null;
        return this.getCurrentAcceptanceTestRun();
    }

    public void testRunStarted(Description description) throws Exception {
        this.getNewCurrentAcceptanceTestRun();
        this.getCurrentAcceptanceTestRun().setMethodName(description.getMethodName());
        this.getCurrentAcceptanceTestRun().setUserStory(this.withUserStoryFrom(description));
        this.acceptanceTestRuns.add(this.getCurrentAcceptanceTestRun());
        this.updateTestRunTitleBasedOn(description);
        this.updateTestRunRequirementsBasedOn(description);
        this.getCurrentTestStepFrom(description);
    }

    public void testStarted(Description description) throws Exception {
        AnnotatedDescription testDescription = new AnnotatedDescription(description);
        if (testDescription.isAGroup()) {
            this.testGroupStarted(testDescription);
        } else {
            super.testStarted(description);
            this.getCurrentTestStepFrom(description);
        }
    }

    public void testGroupStarted(AnnotatedDescription testDescription) {
        this.getCurrentAcceptanceTestRun().startGroup(testDescription.getGroupName());
    }

    private UserStory withUserStoryFrom(Description description) {
        String name = NameConverter.humanize((String)description.getTestClass().getSimpleName());
        String code = this.userStoryCodeFromAnnotationIfPresentIn(description.getTestClass());
        String source = description.getTestClass().getCanonicalName();
        return new UserStory(name, code, source);
    }

    private String userStoryCodeFromAnnotationIfPresentIn(Class<?> testClass) {
        UserStoryCode userStoryAnnotation = testClass.getAnnotation(UserStoryCode.class);
        if (userStoryAnnotation != null) {
            return userStoryAnnotation.value();
        }
        return "";
    }

    public void testIgnored(Description description) throws Exception {
        this.getCurrentTestStepFrom(description);
        this.markCurrentTestAs(TestResult.IGNORED);
        AnnotatedDescription testDescription = new AnnotatedDescription(description);
        Method testMethod = testDescription.getTestMethod();
        if (TestStatus.of(testMethod).isPending()) {
            this.markCurrentTestAs(TestResult.PENDING);
        } else if (TestStatus.of(testMethod).isIgnored()) {
            this.markCurrentTestAs(TestResult.IGNORED);
        } else {
            this.markCurrentTestAs(TestResult.SKIPPED);
        }
        this.recordCurrentTestStep(description);
    }

    private void markCurrentTestAs(TestResult result) {
        this.currentTestStep.setResult(result);
    }

    public void testFailure(Failure failure) throws Exception {
        this.getCurrentTestStepFrom(failure.getDescription());
        this.markCurrentTestAs(TestResult.FAILURE);
        this.recordFailureDetailsInFailingTestStep(failure);
        this.takeScreenshotFor(failure.getDescription());
        this.recordCurrentTestStep(failure.getDescription());
    }

    private void recordFailureDetailsInFailingTestStep(Failure failure) {
        if (!this.currentTestStep.isAGroup()) {
            this.currentTestStep.failedWith(failure.getMessage(), failure.getException());
        }
    }

    public void testFinished(Description description) throws Exception {
        AnnotatedDescription testDescription = new AnnotatedDescription(description);
        if (testDescription.isAGroup()) {
            this.getCurrentAcceptanceTestRun().endGroup();
        } else {
            this.getCurrentTestStepFrom(description);
            this.markCurrentTestAs(TestResult.SUCCESS);
            this.takeScreenshotFor(description);
            this.recordCurrentTestStep(description);
        }
    }

    private void takeScreenshotFor(Description description) throws IOException {
        File screenshot = this.grabScreenshotFileFor(this.aTestCalled(description));
        this.currentTestStep.setScreenshot(screenshot);
    }

    protected String aTestCalled(Description description) {
        return description.getMethodName();
    }

    private void updateTestRunTitleBasedOn(Description description) {
        if (this.getCurrentAcceptanceTestRun().getTitle() == null) {
            AnnotatedDescription testDescription = new AnnotatedDescription(description);
            this.getCurrentAcceptanceTestRun().setTitle(testDescription.getTitle());
        }
    }

    private void updateTestRunRequirementsBasedOn(Description description) {
        AnnotatedDescription testDescription = new AnnotatedDescription(description);
        List<String> requirements = testDescription.getAnnotatedRequirements();
        for (String requirement : requirements) {
            this.getCurrentAcceptanceTestRun().testsRequirement(requirement);
        }
    }
}

