/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.steps;

import java.util.List;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.ScenarioSteps;
import net.thucydides.junit.internals.PagesAnnotatedField;
import net.thucydides.junit.internals.StepsAnnotatedField;
import net.thucydides.junit.steps.StepFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StepAnnotations {
    private StepAnnotations() {
    }

    public static void injectScenarioStepsInto(Object testCase, StepFactory stepFactory) {
        List<StepsAnnotatedField> stepsFields = StepsAnnotatedField.findMandatoryAnnotatedFields(testCase.getClass());
        StepAnnotations.instanciateScenarioStepFields(testCase, stepFactory, stepsFields);
    }

    public static void injectNestedScenarioStepsInto(ScenarioSteps scenarioSteps, StepFactory stepFactory, Class<? extends ScenarioSteps> scenarioStepsClass) {
        List<StepsAnnotatedField> stepsFields = StepsAnnotatedField.findOptionalAnnotatedFields(scenarioStepsClass);
        StepAnnotations.instanciateScenarioStepFields(scenarioSteps, stepFactory, stepsFields);
    }

    private static void instanciateScenarioStepFields(Object testCaseOrSteps, StepFactory stepFactory, List<StepsAnnotatedField> stepsFields) {
        for (StepsAnnotatedField stepsField : stepsFields) {
            Class<? extends ScenarioSteps> scenarioStepsClass = stepsField.getFieldClass();
            ScenarioSteps steps = stepFactory.newSteps(scenarioStepsClass);
            StepAnnotations.injectNestedScenarioStepsInto(steps, stepFactory, scenarioStepsClass);
            stepsField.setValue(testCaseOrSteps, steps);
        }
    }

    public static void injectAnnotatedPagesObjectInto(Object testCase, Pages pages) {
        PagesAnnotatedField pagesField = PagesAnnotatedField.findFirstAnnotatedField(testCase.getClass());
        if (pagesField != null) {
            pages.setDefaultBaseUrl(pagesField.getDefaultBaseUrl());
            pagesField.setValue(testCase, pages);
        }
    }
}

