/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.steps;

import java.util.ArrayList;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.ScenarioSteps;
import net.thucydides.junit.steps.StepAnnotations;
import net.thucydides.junit.steps.StepInterceptor;
import org.junit.runner.notification.RunListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepFactory {
    private final Pages pages;
    private final List<RunListener> listeners = new ArrayList<RunListener>();
    private final List<ScenarioSteps> managedSteps = new ArrayList<ScenarioSteps>();
    private static final Class<?>[] CONSTRUCTOR_ARG_TYPES = new Class[]{Pages.class};

    public StepFactory(Pages pages) {
        this.pages = pages;
    }

    public void addListener(RunListener listener) {
        this.listeners.add(listener);
    }

    public ScenarioSteps newSteps(Class<? extends ScenarioSteps> scenarioStepsClass) {
        Enhancer e = new Enhancer();
        e.setSuperclass(scenarioStepsClass);
        StepInterceptor stepInterceptor = new StepInterceptor(scenarioStepsClass, this.listeners);
        e.setCallback((Callback)stepInterceptor);
        Object[] arguments = new Object[]{this.pages};
        ScenarioSteps steps = (ScenarioSteps)e.create((Class[])CONSTRUCTOR_ARG_TYPES, arguments);
        this.instanciateAnyNestedStepLibrariesIn(steps, scenarioStepsClass);
        this.managedSteps.add(steps);
        return steps;
    }

    private void instanciateAnyNestedStepLibrariesIn(ScenarioSteps steps, Class<? extends ScenarioSteps> scenarioStepsClass) {
        StepAnnotations.injectNestedScenarioStepsInto(steps, this, scenarioStepsClass);
    }

    public void notifyStepFailures() {
        for (ScenarioSteps step : this.managedSteps) {
            step.done();
        }
    }
}

