/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.steps;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.thucydides.core.annotations.Pending;
import net.thucydides.core.annotations.Step;
import net.thucydides.core.annotations.StepGroup;
import net.thucydides.junit.steps.StepResult;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepInterceptor
implements MethodInterceptor {
    private final List<RunListener> listeners;
    private final Class<?> testStepClass;
    private StepResult resultTally;
    private List<Throwable> stepExceptions;
    private boolean failureHasOccured = false;
    private Throwable error = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(StepInterceptor.class);

    public StepInterceptor(Class<?> testStepClass, List<RunListener> listeners) {
        this.testStepClass = testStepClass;
        this.listeners = listeners;
        this.failureHasOccured = false;
        this.resultTally = new StepResult();
        this.stepExceptions = new ArrayList<Throwable>();
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        if (this.invokingLast(method)) {
            this.notifyFinished(method);
            this.ifAnErrorOccuredThrow(this.error);
            return null;
        }
        Object result = null;
        if (this.isATestGroup(method)) {
            this.notifyGroupStarted(method, args);
            result = this.runTestGroupStep(obj, method, args, proxy);
            this.notifyGroupFinished(method, args);
        } else {
            result = this.testStepResult(obj, method, args, proxy);
        }
        return result;
    }

    private Object testStepResult(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        if (!this.isATestStep(method)) {
            return this.invokeMethod(obj, method, args, proxy);
        }
        this.notifyTestStarted(method, args);
        if (this.isPending(method) || this.isIgnored(method)) {
            this.notifyTestSkippedFor(method, args);
            return null;
        }
        if (this.failureHasOccured) {
            this.notifyTestSkippedFor(method, args);
            return null;
        }
        return this.runTestStep(obj, method, args, proxy);
    }

    private Object runTestGroupStep(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        Object result;
        block2: {
            LOGGER.info("Running test step group " + this.getTestNameFrom(method, args, false));
            result = null;
            try {
                result = proxy.invokeSuper(obj, args);
            }
            catch (Throwable e) {
                if (this.stepExceptions.contains(e)) break block2;
                throw e;
            }
        }
        return result;
    }

    private boolean isATestGroup(Method method) {
        return this.getTestGroupAnnotationFor(method) != null;
    }

    private StepGroup getTestGroupAnnotationFor(Method method) {
        return method.getAnnotation(StepGroup.class);
    }

    private boolean isATestStep(Method method) {
        Step stepAnnotation = method.getAnnotation(Step.class);
        return stepAnnotation != null;
    }

    private boolean isIgnored(Method method) {
        Ignore ignoreAnnotation = method.getAnnotation(Ignore.class);
        return ignoreAnnotation != null;
    }

    private Object runTestStep(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        LOGGER.info("Running test step " + this.getTestNameFrom(method, args, false));
        Object result = null;
        try {
            result = proxy.invokeSuper(obj, args);
            this.notifyTestFinishedFor(method, args);
        }
        catch (Throwable e) {
            this.error = e;
            this.stepExceptions.add(e);
            this.notifyFailureOf(method, args, e);
            this.failureHasOccured = true;
        }
        this.resultTally.logExecutedTest();
        LOGGER.info("Test step done: " + this.getTestNameFrom(method, args, false));
        return result;
    }

    private Object invokeMethod(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        return proxy.invokeSuper(obj, args);
    }

    private boolean isPending(Method method) {
        Pending pendingAnnotation = method.getAnnotation(Pending.class);
        return pendingAnnotation != null;
    }

    private void notifyTestFinishedFor(Method method, Object[] args) throws Exception {
        Description description = Description.createTestDescription(this.testStepClass, (String)this.getTestNameFrom(method, args));
        for (RunListener listener : this.listeners) {
            listener.testFinished(description);
        }
    }

    private String getTestNameFrom(Method method, Object[] args) {
        return this.getTestNameFrom(method, args, true);
    }

    private String getTestNameFrom(Method method, Object[] args, boolean addMarkup) {
        if (args == null || args.length == 0) {
            return method.getName();
        }
        return this.testNameWithArguments(method, args, addMarkup);
    }

    private String testNameWithArguments(Method method, Object[] args, boolean addMarkup) {
        StringBuffer testName = new StringBuffer(method.getName());
        testName.append(": ");
        if (addMarkup) {
            if (args.length == 1) {
                testName.append("<span class='single-parameter'>");
            } else {
                testName.append("<span class='parameters'>");
            }
        }
        boolean isFirst = true;
        for (Object arg : args) {
            if (!isFirst) {
                testName.append(", ");
            }
            testName.append(arg);
            isFirst = false;
        }
        if (addMarkup) {
            testName.append("</span>");
        }
        return testName.toString();
    }

    private void notifyTestSkippedFor(Method method, Object[] args) throws Exception {
        Description description = Description.createTestDescription(this.testStepClass, (String)this.getTestNameFrom(method, args));
        for (RunListener listener : this.listeners) {
            listener.testIgnored(description);
        }
        this.resultTally.logIgnoredTest();
    }

    private void ifAnErrorOccuredThrow(Throwable theError) throws Throwable {
        if (theError != null) {
            throw theError;
        }
    }

    private void notifyFailureOf(Method method, Object[] args, Throwable e) throws Exception {
        Description description = Description.createTestDescription(this.testStepClass, (String)this.getTestNameFrom(method, args));
        Failure failure = new Failure(description, e);
        for (RunListener listener : this.listeners) {
            listener.testFailure(failure);
        }
        this.resultTally.logFailure(failure);
    }

    private void notifyFinished(Method method) throws Exception {
        for (RunListener listener : this.listeners) {
            listener.testRunFinished((Result)this.resultTally);
        }
    }

    private void notifyGroupStarted(Method method, Object[] args) throws Exception {
        Description description = Description.createTestDescription(this.testStepClass, (String)this.getTestNameFrom(method, args));
        for (RunListener listener : this.listeners) {
            listener.testStarted(description);
        }
    }

    private void notifyGroupFinished(Method method, Object[] args) throws Exception {
        Description description = Description.createTestDescription(this.testStepClass, (String)this.getTestNameFrom(method, args));
        for (RunListener listener : this.listeners) {
            listener.testFinished(description);
        }
    }

    private void notifyTestStarted(Method method, Object[] args) throws Exception {
        Description description = Description.createTestDescription(this.testStepClass, (String)this.getTestNameFrom(method, args));
        for (RunListener listener : this.listeners) {
            listener.testStarted(description);
        }
    }

    private boolean invokingLast(Method method) {
        return method.getName().equals("done") || method.getName().equals("finalize");
    }
}

