/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.steps;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepResult
extends Result {
    private List<Failure> failures = new ArrayList<Failure>();
    private int ignored = 0;
    private int run = 0;

    public void logFailure(Failure failure) {
        this.failures.add(failure);
    }

    public void logIgnoredTest() {
        ++this.ignored;
    }

    public void logExecutedTest() {
        ++this.run;
    }

    public int getFailureCount() {
        return this.failures.size();
    }

    public List<Failure> getFailures() {
        return ImmutableList.copyOf(this.failures);
    }

    public int getIgnoreCount() {
        return this.ignored;
    }

    public int getRunCount() {
        return this.run;
    }

    public boolean wasSuccessful() {
        return this.getFailureCount() == 0;
    }
}

