/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.runners;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.junit.annotations.Concurrent;
import net.thucydides.junit.runners.DataDrivenAnnotations;
import net.thucydides.junit.runners.ParameterizedRunnerScheduler;
import net.thucydides.junit.runners.QualifierFinder;
import net.thucydides.junit.runners.TestClassRunnerForInstanciatedTestCase;
import net.thucydides.junit.runners.TestClassRunnerForParameters;
import net.thucydides.junit.runners.ThucydidesRunner;
import org.apache.commons.lang.StringUtils;
import org.junit.runner.Runner;
import org.junit.runners.Suite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThucydidesParameterizedRunner
extends Suite {
    private static final int AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
    private final List<Runner> runners = new ArrayList<Runner>();

    public ThucydidesParameterizedRunner(Class<?> klass, WebDriverFactory webDriverFactory) throws Throwable {
        super(klass, Collections.emptyList());
        DataDrivenAnnotations testClassAnnotations;
        if (this.runTestsInParallelFor(klass)) {
            this.scheduleParallelTestRunsFor(klass);
        }
        if ((testClassAnnotations = this.getTestAnnotations()).hasTestDataDefined()) {
            this.buildTestRunnersForEachDataSetUsing(webDriverFactory);
        } else if (testClassAnnotations.hasTestDataSourceDefined()) {
            this.buildTestRunnersFromADataSourceUsing(webDriverFactory);
        }
    }

    private void buildTestRunnersWithTestSpecificDataSetsUsing(WebDriverFactory webDriverFactory) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private void scheduleParallelTestRunsFor(Class<?> klass) {
        this.setScheduler(new ParameterizedRunnerScheduler(klass, this.getThreadCountFor(klass)));
    }

    protected boolean runTestsInParallelFor(Class<?> klass) {
        return klass.getAnnotation(Concurrent.class) != null;
    }

    protected int getThreadCountFor(Class<?> klass) {
        Concurrent concurrent = klass.getAnnotation(Concurrent.class);
        String threadValue = concurrent.threads();
        int threads = AVAILABLE_PROCESSORS * 2;
        if (StringUtils.isNotEmpty((String)threadValue)) {
            if (StringUtils.isNumeric((String)threadValue)) {
                threads = Integer.valueOf(threadValue);
            } else if (threadValue.endsWith("x")) {
                threads = this.getRelativeThreadCount(threadValue);
            }
        }
        return threads;
    }

    private int getRelativeThreadCount(String threadValue) {
        try {
            String threadCount = threadValue.substring(0, threadValue.length() - 1);
            return Integer.valueOf(threadCount) * AVAILABLE_PROCESSORS;
        }
        catch (NumberFormatException cause) {
            throw new IllegalArgumentException("Illegal thread value: " + threadValue, cause);
        }
    }

    private void buildTestRunnersForEachDataSetUsing(WebDriverFactory webDriverFactory) throws Throwable {
        List<Object[]> parametersList = this.getTestAnnotations().getParametersList();
        for (int i = 0; i < parametersList.size(); ++i) {
            Class testClass = this.getTestClass().getJavaClass();
            TestClassRunnerForParameters runner = new TestClassRunnerForParameters(testClass, parametersList, i);
            runner.useQualifier(this.from(parametersList.get(i)));
            this.overrideWebdriverFactoryIfProvided(runner, webDriverFactory);
            this.runners.add((Runner)runner);
        }
    }

    private void buildTestRunnersFromADataSourceUsing(WebDriverFactory webDriverFactory) throws Throwable {
        List testClasses = this.getTestAnnotations().getDataAsInstancesOf(this.getTestClass().getJavaClass());
        for (int i = 0; i < testClasses.size(); ++i) {
            Object testCase = testClasses.get(i);
            TestClassRunnerForInstanciatedTestCase runner = new TestClassRunnerForInstanciatedTestCase(testCase, i);
            runner.useQualifier(this.getQualifierFor(testCase));
            this.overrideWebdriverFactoryIfProvided(runner, webDriverFactory);
            this.runners.add((Runner)runner);
        }
    }

    private String getQualifierFor(Object testCase) {
        return QualifierFinder.forTestCase(testCase).getQualifier();
    }

    private DataDrivenAnnotations getTestAnnotations() {
        return DataDrivenAnnotations.forClass(this.getTestClass());
    }

    private String from(Object[] testData) {
        StringBuffer testDataQualifier = new StringBuffer();
        boolean firstEntry = true;
        for (Object testDataValue : testData) {
            if (!firstEntry) {
                testDataQualifier.append("_");
            }
            testDataQualifier.append(testDataValue);
            firstEntry = false;
        }
        return testDataQualifier.toString();
    }

    public ThucydidesParameterizedRunner(Class<?> klass) throws Throwable {
        this(klass, null);
    }

    private void overrideWebdriverFactoryIfProvided(ThucydidesRunner runner, WebDriverFactory webDriverFactory) {
        if (webDriverFactory != null) {
            runner.setWebDriverFactory(webDriverFactory);
        }
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    public List<TestOutcome> getTestOutcomes() {
        ArrayList<TestOutcome> testOutcomes = new ArrayList<TestOutcome>();
        testOutcomes.addAll(((ThucydidesRunner)this.runners.get(0)).getTestOutcomes());
        for (Runner runner : this.runners) {
            for (TestOutcome testOutcome : ((ThucydidesRunner)runner).getTestOutcomes()) {
                if (testOutcomes.contains(testOutcome)) continue;
                testOutcomes.add(testOutcome);
            }
        }
        return testOutcomes;
    }
}

