/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.runners;

import java.io.File;
import java.util.Collection;
import java.util.List;
import net.thucydides.core.annotations.Pending;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.ReportService;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepData;
import net.thucydides.core.steps.StepFactory;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebdriverManager;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import net.thucydides.junit.listeners.JUnitStepListener;
import net.thucydides.junit.runners.TestCaseAnnotations;
import net.thucydides.junit.runners.ThucydidesStatement;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThucydidesRunner
extends BlockJUnit4ClassRunner {
    private WebDriverFactory webDriverFactory;
    private StepFactory stepFactory;
    private Pages pages;
    private WebdriverManager webdriverManager;
    private JUnitStepListener stepListener;
    private Configuration configuration;
    private static final Logger LOGGER = LoggerFactory.getLogger(ThucydidesRunner.class);
    private ReportService reportService;

    public JUnitStepListener getStepListener() {
        return this.stepListener;
    }

    protected void setStepListener(JUnitStepListener stepListener) {
        this.stepListener = stepListener;
    }

    public Pages getPages() {
        return this.pages;
    }

    public ThucydidesRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.checkRequestedDriverType();
        TestCaseAnnotations.checkThatTestCaseIsCorrectlyAnnotated(klass);
        this.initializeReportService();
        this.webDriverFactory = new WebDriverFactory();
    }

    protected Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new Configuration();
        }
        return this.configuration;
    }

    private void checkRequestedDriverType() {
        Configuration.getDriverType();
    }

    public void setWebDriverFactory(WebDriverFactory webDriverFactory) {
        this.webDriverFactory = webDriverFactory;
    }

    public File getOutputDirectory() {
        return this.getConfiguration().getOutputDirectory();
    }

    public void subscribeReporter(AcceptanceTestReporter reporter) {
        this.reportService.subscribe(reporter);
    }

    public void useQualifier(String qualifier) {
        this.reportService.useQualifier(qualifier);
    }

    public void run(RunNotifier notifier) {
        WebDriver driver = this.initWebdriverManager();
        Pages newPages = this.initPagesObjectUsing(driver);
        JUnitStepListener newStepListener = this.initListenersUsing(newPages);
        notifier.addListener((RunListener)newStepListener);
        this.initStepFactoryUsing(newPages, newStepListener);
        super.run(notifier);
        this.closeDriver();
        this.generateReportsFor(this.getStepListener().getTestOutcomes());
        this.notifyFailures();
    }

    private Pages initPagesObjectUsing(WebDriver driver) {
        this.pages = new Pages(driver);
        return this.pages;
    }

    protected JUnitStepListener initListenersUsing(Pages pagesObject) {
        this.setStepListener(new JUnitStepListener(Configuration.loadOutputDirectoryFromSystemProperties(), pagesObject));
        return this.stepListener;
    }

    private void initStepFactoryUsing(Pages pagesObject, JUnitStepListener listener) {
        this.stepFactory = new StepFactory(pagesObject);
        this.stepFactory.addListener((StepListener)listener.getBaseStepListener());
    }

    private void closeDriver() {
        this.getWebdriverManager().closeDriver();
    }

    protected WebdriverManager getWebdriverManager() {
        return this.webdriverManager;
    }

    protected WebDriver initWebdriverManager() {
        this.webdriverManager = new WebdriverManager(this.webDriverFactory);
        return this.webdriverManager.getWebdriver();
    }

    private void initializeReportService() {
        this.reportService = new ReportService(this.getConfiguration().getOutputDirectory(), this.getDefaultReporters());
    }

    private void notifyFailures() {
        this.stepFactory.notifyStepFinished();
    }

    private void generateReportsFor(List<TestOutcome> testOutcomeResults) {
        this.reportService.generateReportsFor(testOutcomeResults);
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        this.resetBroswerFromTimeToTime();
        Description description = this.describeChild(method);
        if (method.getAnnotation(Pending.class) != null) {
            notifier.fireTestIgnored(description);
        } else {
            super.runChild(method, notifier);
        }
    }

    protected boolean restartBrowserBeforeTest() {
        return false;
    }

    protected void resetBroswerFromTimeToTime() {
        if (this.restartBrowserBeforeTest()) {
            LOGGER.info("Restarting browser");
            WebdriverProxyFactory.resetDriver((WebDriver)this.getDriver());
        }
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        this.noStepsHaveFailed();
        this.injectDriverInto(test);
        this.injectAnnotatedPagesObjectInto(test);
        this.injectScenarioStepsInto(test);
        this.stepFactory.addListener((StepListener)this.getStepListener().getBaseStepListener());
        this.useStepFactoryForDataDrivenSteps();
        Statement baseStatement = super.methodInvoker(method, test);
        return new ThucydidesStatement(baseStatement, (StepListener)this.stepListener.getBaseStepListener());
    }

    private void useStepFactoryForDataDrivenSteps() {
        StepData.setDefaultStepFactory((StepFactory)this.stepFactory);
    }

    private void noStepsHaveFailed() {
        this.getStepListener().getBaseStepListener().noStepsHaveFailed();
    }

    protected void injectDriverInto(Object testCase) {
        TestCaseAnnotations.forTestCase(testCase).injectDriver(this.getDriver());
    }

    protected void injectScenarioStepsInto(Object testCase) {
        StepAnnotations.injectScenarioStepsInto((Object)testCase, (StepFactory)this.stepFactory);
    }

    protected void injectAnnotatedPagesObjectInto(Object testCase) {
        this.getPages().notifyWhenDriverOpens();
        StepAnnotations.injectAnnotatedPagesObjectInto((Object)testCase, (Pages)this.pages);
    }

    protected WebDriver getDriver() {
        return this.getWebdriverManager().getWebdriver();
    }

    public List<TestOutcome> getTestOutcomes() {
        return this.getStepListener().getTestOutcomes();
    }

    protected Collection<AcceptanceTestReporter> getDefaultReporters() {
        return ReportService.getDefaultReporters();
    }
}

