/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.internals;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import net.thucydides.junit.annotations.InvalidManagedWebDriverFieldException;
import net.thucydides.junit.annotations.Managed;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedWebDriverAnnotatedField {
    private static final String NO_ANNOTATED_FIELD_ERROR = "No WebDriver field annotated with @Managed was found in the test case.";
    private Field field;

    public static ManagedWebDriverAnnotatedField findFirstAnnotatedField(Class<?> testClass) {
        for (Field field : testClass.getDeclaredFields()) {
            if (!ManagedWebDriverAnnotatedField.isFieldAnnotated(field)) continue;
            return new ManagedWebDriverAnnotatedField(field);
        }
        throw new InvalidManagedWebDriverFieldException(NO_ANNOTATED_FIELD_ERROR);
    }

    private static boolean isFieldAnnotated(Field field) {
        return ManagedWebDriverAnnotatedField.fieldIsAnnotatedCorrectly(field) && ManagedWebDriverAnnotatedField.fieldIsRightType(field);
    }

    private static boolean fieldIsRightType(Field field) {
        return field.getType().isAssignableFrom(WebDriver.class);
    }

    private static boolean fieldIsAnnotatedCorrectly(Field field) {
        boolean managedAnnotationFound = false;
        for (Annotation annotation : field.getAnnotations()) {
            if (!(annotation instanceof Managed)) continue;
            managedAnnotationFound = true;
            break;
        }
        return managedAnnotationFound;
    }

    protected ManagedWebDriverAnnotatedField(Field field) {
        this.field = field;
    }

    public void setValue(Object testCase, WebDriver manageDriver) {
        try {
            this.field.set(testCase, manageDriver);
        }
        catch (IllegalAccessException e) {
            throw new InvalidManagedWebDriverFieldException("Could not access or set web driver field: " + this.field + " - is this field public?", e);
        }
    }
}

