/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.listeners;

import java.io.File;
import java.util.List;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.TestStepResult;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitStepListener
extends RunListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(JUnitStepListener.class);
    private BaseStepListener baseStepListener;
    private boolean initialTest = true;

    public JUnitStepListener(File outputDirectory, Pages pages) {
        this.baseStepListener = new BaseStepListener(outputDirectory, pages);
    }

    public BaseStepListener getBaseStepListener() {
        return this.baseStepListener;
    }

    public void testStarted(Description description) throws Exception {
        LOGGER.debug("Junit notification: test started for {}", (Object)description.getMethodName());
        if (this.initialTest) {
            this.baseStepListener.testRunStartedFor(description.getTestClass());
            this.initialTest = false;
        }
        String methodName = description.getMethodName();
        this.baseStepListener.testStarted(methodName);
    }

    private ExecutedStepDescription withDescriptionFrom(Description description) {
        Class stepsClass = description.getTestClass();
        return ExecutedStepDescription.of((Class)stepsClass, (String)description.getMethodName());
    }

    public void testFinished(Description description) throws Exception {
        LOGGER.debug("Junit notification: test finished for {}", (Object)description.getMethodName());
        this.baseStepListener.testFinished(new TestStepResult());
    }

    public void testFailure(Failure failure) throws Exception {
        this.baseStepListener.stepFailed(new StepFailure(ExecutedStepDescription.withTitle((String)failure.getMessage()), failure.getException()));
    }

    public void testIgnored(Description description) throws Exception {
        this.baseStepListener.stepIgnored(this.withDescriptionFrom(description));
    }

    public List<TestOutcome> getTestOutcomes() {
        return this.baseStepListener.getTestOutcomes();
    }

    public Throwable getError() {
        return this.baseStepListener.getStepError();
    }

    public boolean hasRecordedFailures() {
        return this.baseStepListener.aStepHasFailed();
    }

    public void resetStepFailures() {
        this.baseStepListener.noStepsHaveFailed();
    }
}

