/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.listeners;

import java.io.File;
import java.util.List;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepListener;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitStepListener
extends RunListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(JUnitStepListener.class);
    private BaseStepListener baseStepListener;
    private boolean firstTest = true;

    public JUnitStepListener(File outputDirectory, Pages pages) {
        this.baseStepListener = new BaseStepListener(outputDirectory, pages);
        StepEventBus.getEventBus().registerListener((StepListener)this.baseStepListener);
    }

    public BaseStepListener getBaseStepListener() {
        return this.baseStepListener;
    }

    public void testRunStarted(Description description) throws Exception {
        super.testRunStarted(description);
    }

    public void testRunFinished(Result result) throws Exception {
        super.testRunFinished(result);
    }

    public void testStarted(Description description) {
        LOGGER.debug("Junit notification: test started for {}", (Object)description.getMethodName());
        StepEventBus.getEventBus().clear();
        if (this.firstTest) {
            StepEventBus.getEventBus().testSuiteStarted(description.getTestClass());
            this.firstTest = false;
        }
        StepEventBus.getEventBus().testStarted(description.getMethodName());
    }

    public void testFinished(Description description) throws Exception {
        LOGGER.debug("Junit notification: test finished for {}", (Object)description.getMethodName());
    }

    public void testFailure(Failure failure) throws Exception {
        StepEventBus.getEventBus().testFailed(failure.getException());
    }

    public void testIgnored(Description description) throws Exception {
        StepEventBus.getEventBus().testIgnored();
    }

    public List<TestOutcome> getTestOutcomes() {
        return this.baseStepListener.getTestOutcomes();
    }

    public Throwable getError() {
        return this.baseStepListener.getTestFailureCause();
    }

    public boolean hasRecordedFailures() {
        return this.baseStepListener.aStepHasFailed();
    }

    public void close() {
        StepEventBus.getEventBus().dropListener((StepListener)this.baseStepListener);
    }
}

