/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.runners;

import java.io.File;
import java.util.Collection;
import java.util.List;
import net.thucydides.core.annotations.Pending;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.ReportService;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepData;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFactory;
import net.thucydides.core.steps.StepPublisher;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebdriverManager;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import net.thucydides.junit.listeners.JUnitStepListener;
import net.thucydides.junit.runners.TestCaseAnnotations;
import net.thucydides.junit.runners.ThucydidesStatement;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThucydidesRunner
extends BlockJUnit4ClassRunner {
    private WebDriverFactory webDriverFactory;
    private StepFactory stepFactory;
    private Pages pages;
    private WebdriverManager webdriverManager;
    private JUnitStepListener stepListener;
    private Configuration configuration;
    private static final Logger LOGGER = LoggerFactory.getLogger(ThucydidesRunner.class);
    private ReportService reportService;
    private boolean uniqueSession;

    public JUnitStepListener getStepListener() {
        return this.stepListener;
    }

    protected void setStepListener(JUnitStepListener stepListener) {
        this.stepListener = stepListener;
    }

    public Pages getPages() {
        return this.pages;
    }

    public ThucydidesRunner(Class<?> klass) throws InitializationError {
        this(klass, new WebDriverFactory());
    }

    public ThucydidesRunner(Class<?> klass, WebDriverFactory webDriverFactory) throws InitializationError {
        super(klass);
        this.checkRequestedDriverType();
        TestCaseAnnotations.checkThatTestCaseIsCorrectlyAnnotated(klass);
        this.webDriverFactory = webDriverFactory;
    }

    protected Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = (Configuration)Injectors.getInjector().getInstance(Configuration.class);
        }
        return this.configuration;
    }

    private void checkRequestedDriverType() {
        this.getConfiguration().getDriverType();
    }

    public void setWebDriverFactory(WebDriverFactory webDriverFactory) {
        this.webDriverFactory = webDriverFactory;
    }

    public File getOutputDirectory() {
        return this.getConfiguration().getOutputDirectory();
    }

    public void subscribeReporter(AcceptanceTestReporter reporter) {
        this.getReportService().subscribe(reporter);
    }

    public void useQualifier(String qualifier) {
        this.getReportService().useQualifier(qualifier);
    }

    public void run(RunNotifier notifier) {
        this.initializeDriversAndListeners(notifier);
        super.run(notifier);
        this.stepListener.close();
        this.generateReportsFor(this.stepListener.getTestOutcomes());
        this.notifyFailures();
        this.closeDriver();
    }

    private void initializeDriversAndListeners(RunNotifier notifier) {
        this.initWebdriverManager();
        this.initStepEventBus();
        Pages newPages = this.initPagesObjectUsing(this.webdriverManager.getWebdriver());
        this.initListenersUsing(newPages);
        notifier.addListener((RunListener)this.stepListener);
        this.initStepFactoryUsing(newPages);
    }

    private void initStepEventBus() {
        StepEventBus.getEventBus().clear();
    }

    private Pages initPagesObjectUsing(WebDriver driver) {
        this.pages = new Pages(driver);
        return this.pages;
    }

    protected JUnitStepListener initListenersUsing(Pages pagesObject) {
        this.setStepListener(new JUnitStepListener(this.getConfiguration().loadOutputDirectoryFromSystemProperties(), pagesObject));
        return this.stepListener;
    }

    private void initStepFactoryUsing(Pages pagesObject) {
        this.stepFactory = new StepFactory(pagesObject);
    }

    private void closeDriver() {
        this.getWebdriverManager().closeDriver();
    }

    protected WebdriverManager getWebdriverManager() {
        return this.webdriverManager;
    }

    protected void initWebdriverManager() {
        this.webdriverManager = new WebdriverManager(this.webDriverFactory);
    }

    private ReportService getReportService() {
        if (this.reportService == null) {
            this.reportService = new ReportService(this.getOutputDirectory(), this.getDefaultReporters());
        }
        return this.reportService;
    }

    private void notifyFailures() {
        this.stepFactory.notifyStepFinished();
    }

    private void generateReportsFor(List<TestOutcome> testOutcomeResults) {
        this.getReportService().generateReportsFor(testOutcomeResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        LOGGER.info("Executing test: {}", (Object)method.getName());
        this.resetBroswerFromTimeToTime();
        this.processTestMethodAnnotationsFor(method);
        try {
            super.runChild(method, notifier);
        }
        finally {
            StepEventBus.getEventBus().testFinished(this.getLatestTestOutcome());
        }
    }

    private TestOutcome getLatestTestOutcome() {
        if (this.getTestOutcomes().size() > 0) {
            return this.getTestOutcomes().get(this.getTestOutcomes().size() - 1);
        }
        return null;
    }

    private void processTestMethodAnnotationsFor(FrameworkMethod method) {
        if (this.isPending(method)) {
            StepEventBus.getEventBus().testPending();
        }
        if (this.isIgnored(method)) {
            this.stepListener.testStarted(Description.createTestDescription(method.getMethod().getDeclaringClass(), (String)method.getName()));
            StepEventBus.getEventBus().testIgnored();
        }
    }

    private boolean isPending(FrameworkMethod method) {
        return method.getAnnotation(Pending.class) != null;
    }

    private boolean isIgnored(FrameworkMethod method) {
        return method.getAnnotation(Ignore.class) != null;
    }

    protected boolean restartBrowserBeforeTest() {
        return !this.uniqueSession;
    }

    protected void resetBroswerFromTimeToTime() {
        if (this.restartBrowserBeforeTest()) {
            LOGGER.info("Restarting browser");
            WebdriverProxyFactory.resetDriver((WebDriver)this.getDriver());
        }
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        this.injectDriverInto(test);
        this.injectAnnotatedPagesObjectInto(test);
        this.injectScenarioStepsInto(test);
        this.uniqueSession = TestCaseAnnotations.forTestCase(test).isUniqueSession();
        this.useStepFactoryForDataDrivenSteps();
        Statement baseStatement = super.methodInvoker(method, test);
        return new ThucydidesStatement(baseStatement, (StepPublisher)this.stepListener.getBaseStepListener());
    }

    private void useStepFactoryForDataDrivenSteps() {
        StepData.setDefaultStepFactory((StepFactory)this.stepFactory);
    }

    protected void injectDriverInto(Object testCase) {
        TestCaseAnnotations.forTestCase(testCase).injectDriver(this.getDriver());
    }

    protected void injectScenarioStepsInto(Object testCase) {
        StepAnnotations.injectScenarioStepsInto((Object)testCase, (StepFactory)this.stepFactory);
    }

    protected void injectAnnotatedPagesObjectInto(Object testCase) {
        this.getPages().notifyWhenDriverOpens();
        StepAnnotations.injectAnnotatedPagesObjectInto((Object)testCase, (Pages)this.pages);
    }

    protected WebDriver getDriver() {
        return this.getWebdriverManager().getWebdriver();
    }

    public List<TestOutcome> getTestOutcomes() {
        return this.getStepListener().getTestOutcomes();
    }

    protected Collection<AcceptanceTestReporter> getDefaultReporters() {
        return ReportService.getDefaultReporters();
    }
}

