/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.runners;

import net.thucydides.core.annotations.ManagedWebDriverAnnotatedField;
import net.thucydides.core.pages.PagesAnnotatedField;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestCaseAnnotations {
    private final Object testCase;

    private TestCaseAnnotations(Object testCase) {
        this.testCase = testCase;
    }

    public static TestCaseAnnotations forTestCase(Object testCase) {
        return new TestCaseAnnotations(testCase);
    }

    public static void checkThatTestCaseIsCorrectlyAnnotated(Class<?> testClass) {
        TestCaseAnnotations.checkThatManagedFieldIsDefined(testClass);
        TestCaseAnnotations.checkThatPagesFieldIsDefined(testClass);
    }

    private static void checkThatManagedFieldIsDefined(Class<?> testClass) {
        ManagedWebDriverAnnotatedField.findFirstAnnotatedField(testClass);
    }

    private static void checkThatPagesFieldIsDefined(Class<?> testClass) {
        PagesAnnotatedField.findFirstAnnotatedField(testClass);
    }

    public void injectDriver(WebDriver driver) {
        ManagedWebDriverAnnotatedField webDriverField = ManagedWebDriverAnnotatedField.findFirstAnnotatedField(this.testCase.getClass());
        webDriverField.setValue(this.testCase, driver);
    }

    public boolean isUniqueSession() {
        ManagedWebDriverAnnotatedField webDriverField = ManagedWebDriverAnnotatedField.findFirstAnnotatedField(this.testCase.getClass());
        return webDriverField.isUniqueSession();
    }
}

