/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.runners;

import java.util.List;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.junit.listeners.JUnitStepListener;
import net.thucydides.junit.runners.DataDrivenAnnotations;
import net.thucydides.junit.runners.ParameterizedJUnitStepListener;
import net.thucydides.junit.runners.ThucydidesRunner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

class TestClassRunnerForParameters
extends ThucydidesRunner {
    private final int parameterSetNumber;
    private final List<Object[]> parameterList;

    TestClassRunnerForParameters(Class<?> type, Configuration configuration, WebDriverFactory webDriverFactory, List<Object[]> parameterList, int i) throws InitializationError {
        super(type, webDriverFactory, configuration);
        this.parameterList = parameterList;
        this.parameterSetNumber = i;
    }

    @Override
    protected JUnitStepListener initListenersUsing(Pages pagesObject) {
        this.setStepListener(new ParameterizedJUnitStepListener(this.getConfiguration().loadOutputDirectoryFromSystemProperties(), pagesObject, this.parameterSetNumber));
        return this.getStepListener();
    }

    public Object createTest() throws Exception {
        return this.getTestClass().getOnlyConstructor().newInstance(this.computeParams());
    }

    private Object[] computeParams() throws Exception {
        try {
            return this.parameterList.get(this.parameterSetNumber);
        }
        catch (ClassCastException cause) {
            throw new Exception(String.format("%s.%s() must return a Collection of arrays.", this.getTestClass().getName(), DataDrivenAnnotations.forClass(this.getTestClass()).getTestDataMethod().getName()), cause);
        }
    }

    @Override
    protected boolean restartBrowserBeforeTest() {
        int restartFrequency = this.getConfiguration().getRestartFrequency();
        return this.parameterSetNumber > 0 && this.parameterSetNumber % restartFrequency == 0;
    }

    protected String getName() {
        String firstParameter = this.parameterList.get(this.parameterSetNumber)[0].toString();
        return String.format("[%s]", firstParameter);
    }

    protected String testName(FrameworkMethod method) {
        return String.format("%s[%s]", method.getName(), this.parameterSetNumber);
    }

    protected void validateConstructor(List<Throwable> errors) {
        this.validateOnlyOneConstructor(errors);
    }

    protected Statement classBlock(RunNotifier notifier) {
        return this.childrenInvoker(notifier);
    }
}

