/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.runners;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import net.thucydides.core.Thucydides;
import net.thucydides.core.annotations.ManagedWebDriverAnnotatedField;
import net.thucydides.core.annotations.Pending;
import net.thucydides.core.batches.BatchManager;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.ReportService;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepData;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFactory;
import net.thucydides.core.steps.StepPublisher;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.ThucydidesWebdriverManager;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebdriverManager;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import net.thucydides.junit.listeners.JUnitStepListener;
import net.thucydides.junit.runners.TestCaseAnnotations;
import net.thucydides.junit.runners.TestMethodAnnotations;
import net.thucydides.junit.runners.ThucydidesStatement;
import org.apache.commons.lang3.StringUtils;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThucydidesRunner
extends BlockJUnit4ClassRunner {
    private StepFactory stepFactory;
    private Pages pages;
    private WebdriverManager webdriverManager;
    private String requestedDriver;
    private JUnitStepListener stepListener;
    private Configuration configuration;
    private static final Logger LOGGER = LoggerFactory.getLogger(ThucydidesRunner.class);
    private ReportService reportService;
    private boolean uniqueSession;
    private BatchManager batchManager;

    public JUnitStepListener getStepListener() {
        return this.stepListener;
    }

    protected void setStepListener(JUnitStepListener stepListener) {
        this.stepListener = stepListener;
    }

    public Pages getPages() {
        return this.pages;
    }

    public ThucydidesRunner(Class<?> klass) throws InitializationError {
        this(klass, (BatchManager)Injectors.getInjector().getInstance(BatchManager.class));
    }

    public ThucydidesRunner(Class<?> klass, WebDriverFactory webDriverFactory) throws InitializationError {
        this(klass, webDriverFactory, (Configuration)Injectors.getInjector().getInstance(Configuration.class));
    }

    public ThucydidesRunner(Class<?> klass, WebDriverFactory webDriverFactory, Configuration configuration) throws InitializationError {
        this(klass, (WebdriverManager)new ThucydidesWebdriverManager(webDriverFactory, configuration), configuration, (BatchManager)Injectors.getInjector().getInstance(BatchManager.class));
    }

    public ThucydidesRunner(Class<?> klass, BatchManager batchManager) throws InitializationError {
        this(klass, (WebdriverManager)Injectors.getInjector().getInstance(WebdriverManager.class), (Configuration)Injectors.getInjector().getInstance(Configuration.class), batchManager);
    }

    public ThucydidesRunner(Class<?> klass, WebdriverManager webDriverManager, Configuration configuration, BatchManager batchManager) throws InitializationError {
        super(klass);
        this.webdriverManager = webDriverManager;
        this.configuration = configuration;
        this.requestedDriver = this.getSpecifiedDriver(klass);
        if (TestCaseAnnotations.supportsWebTests(klass)) {
            this.checkRequestedDriverType();
        }
        this.batchManager = batchManager;
        batchManager.registerTestCase(klass);
        this.loadLocalPreferences();
    }

    private void loadLocalPreferences() throws InitializationError {
        try {
            Thucydides.loadLocalPreferences();
        }
        catch (IOException e) {
            throw new InitializationError((Throwable)e);
        }
    }

    private String getSpecifiedDriver(Class<?> klass) {
        if (ManagedWebDriverAnnotatedField.hasManagedWebdriverField(klass)) {
            return ManagedWebDriverAnnotatedField.findFirstAnnotatedField(klass).getDriver();
        }
        return null;
    }

    protected Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = (Configuration)Injectors.getInjector().getInstance(Configuration.class);
        }
        return this.configuration;
    }

    private void checkRequestedDriverType() {
        if (this.requestedDriverSpecified()) {
            SupportedWebDriver.getDriverTypeFor((String)this.requestedDriver);
        } else {
            this.getConfiguration().getDriverType();
        }
    }

    private boolean requestedDriverSpecified() {
        return !StringUtils.isEmpty((CharSequence)this.requestedDriver);
    }

    public File getOutputDirectory() {
        return this.getConfiguration().getOutputDirectory();
    }

    public void subscribeReporter(AcceptanceTestReporter reporter) {
        this.getReportService().subscribe(reporter);
    }

    public void useQualifier(String qualifier) {
        this.getReportService().useQualifier(qualifier);
    }

    public void run(RunNotifier notifier) {
        if (!this.skipThisTest()) {
            this.initializeDriversAndListeners(notifier);
            super.run(notifier);
            this.stepListener.close();
            this.generateReportsFor(this.stepListener.getTestOutcomes());
            this.closeDrivers();
        }
    }

    private boolean skipThisTest() {
        return this.batchManager != null && !this.batchManager.shouldExecuteThisTest();
    }

    private void initializeDriversAndListeners(RunNotifier notifier) {
        this.initWebdriverManager();
        this.initStepEventBus();
        if (this.webtestsAreSupported()) {
            this.initPagesObjectUsing(this.webdriverManager.getWebdriver(this.requestedDriver));
            this.initListenersUsing(this.getPages());
            this.initStepFactoryUsing(this.getPages());
        } else {
            this.initListeners();
            this.initStepFactory();
        }
        notifier.addListener((RunListener)this.stepListener);
    }

    private void initStepEventBus() {
        StepEventBus.getEventBus().clear();
    }

    private void initPagesObjectUsing(WebDriver driver) {
        this.pages = new Pages(driver, this.getConfiguration());
    }

    protected JUnitStepListener initListenersUsing(Pages pagesObject) {
        this.setStepListener(new JUnitStepListener(this.getConfiguration().loadOutputDirectoryFromSystemProperties(), pagesObject));
        return this.stepListener;
    }

    protected JUnitStepListener initListeners() {
        this.setStepListener(new JUnitStepListener(this.getConfiguration().loadOutputDirectoryFromSystemProperties()));
        return this.stepListener;
    }

    private boolean webtestsAreSupported() {
        return TestCaseAnnotations.supportsWebTests(this.getTestClass().getJavaClass());
    }

    private void initStepFactoryUsing(Pages pagesObject) {
        this.stepFactory = new StepFactory(pagesObject);
    }

    private void initStepFactory() {
        this.stepFactory = new StepFactory();
    }

    private void closeDrivers() {
        this.getWebdriverManager().closeAllDrivers();
    }

    protected WebdriverManager getWebdriverManager() {
        return this.webdriverManager;
    }

    protected void initWebdriverManager() {
        if (this.webdriverManager == null) {
            this.webdriverManager = (WebdriverManager)Injectors.getInjector().getInstance(WebdriverManager.class);
        }
    }

    private ReportService getReportService() {
        if (this.reportService == null) {
            this.reportService = new ReportService(this.getOutputDirectory(), this.getDefaultReporters());
        }
        return this.reportService;
    }

    private void generateReportsFor(List<TestOutcome> testOutcomeResults) {
        this.getReportService().generateReportsFor(testOutcomeResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        LOGGER.info("Executing test: {}", (Object)method.getName());
        Thucydides.initializeTestSession();
        this.resetBroswerFromTimeToTime();
        this.processTestMethodAnnotationsFor(method);
        try {
            super.runChild(method, notifier);
        }
        finally {
            StepEventBus.getEventBus().testFinished(this.getLatestTestOutcome());
        }
    }

    private TestOutcome getLatestTestOutcome() {
        if (this.getTestOutcomes().size() > 0) {
            return this.getTestOutcomes().get(this.getTestOutcomes().size() - 1);
        }
        return null;
    }

    private void processTestMethodAnnotationsFor(FrameworkMethod method) {
        if (this.isPending(method)) {
            StepEventBus.getEventBus().testPending();
        } else if (this.isIgnored(method)) {
            this.stepListener.testStarted(Description.createTestDescription(method.getMethod().getDeclaringClass(), (String)method.getName()));
            StepEventBus.getEventBus().testIgnored();
        }
    }

    private boolean isPending(FrameworkMethod method) {
        return method.getAnnotation(Pending.class) != null;
    }

    private boolean isIgnored(FrameworkMethod method) {
        return method.getAnnotation(Ignore.class) != null;
    }

    protected boolean restartBrowserBeforeTest() {
        return !this.uniqueSession;
    }

    protected void resetBroswerFromTimeToTime() {
        if (this.restartBrowserBeforeTest()) {
            LOGGER.info("Restarting browser");
            WebdriverProxyFactory.resetDriver((WebDriver)this.getDriver());
        }
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        if (this.webtestsAreSupported()) {
            this.injectDriverInto(test, method);
            this.initPagesObjectUsing(this.driverFor(method));
            this.injectAnnotatedPagesObjectInto(test);
            this.initStepFactoryUsing(this.getPages());
            this.uniqueSession = TestCaseAnnotations.forTestCase(test).isUniqueSession();
        }
        this.injectScenarioStepsInto(test);
        this.useStepFactoryForDataDrivenSteps();
        Statement baseStatement = super.methodInvoker(method, test);
        return new ThucydidesStatement(baseStatement, (StepPublisher)this.stepListener.getBaseStepListener());
    }

    private void useStepFactoryForDataDrivenSteps() {
        StepData.setDefaultStepFactory((StepFactory)this.stepFactory);
    }

    protected void injectDriverInto(Object testCase, FrameworkMethod method) {
        TestCaseAnnotations.forTestCase(testCase).injectDriver(this.driverFor(method));
    }

    protected WebDriver driverFor(FrameworkMethod method) {
        if (TestMethodAnnotations.forTest(method).isDriverSpecified()) {
            String testSpecificDriver = TestMethodAnnotations.forTest(method).specifiedDriver();
            return this.getDriver(testSpecificDriver);
        }
        return this.getDriver();
    }

    protected void injectScenarioStepsInto(Object testCase) {
        StepAnnotations.injectScenarioStepsInto((Object)testCase, (StepFactory)this.stepFactory);
    }

    protected void injectAnnotatedPagesObjectInto(Object testCase) {
        this.getPages().notifyWhenDriverOpens();
        StepAnnotations.injectAnnotatedPagesObjectInto((Object)testCase, (Pages)this.pages);
    }

    protected WebDriver getDriver() {
        return this.getWebdriverManager().getWebdriver(this.requestedDriver);
    }

    protected WebDriver getDriver(String driver) {
        return this.getWebdriverManager().getWebdriver(driver);
    }

    public List<TestOutcome> getTestOutcomes() {
        return this.getStepListener().getTestOutcomes();
    }

    protected Collection<AcceptanceTestReporter> getDefaultReporters() {
        return ReportService.getDefaultReporters();
    }
}

