/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.runners;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.reflect.Field;
import net.thucydides.core.annotations.Managed;
import net.thucydides.core.annotations.ManagedWebDriverAnnotatedField;
import org.openqa.selenium.WebDriver;

public final class TestCaseAnnotations {
    private final Object testCase;

    private TestCaseAnnotations(Object testCase) {
        this.testCase = testCase;
    }

    public static TestCaseAnnotations forTestCase(Object testCase) {
        return new TestCaseAnnotations(testCase);
    }

    public void injectDriver(WebDriver driver) {
        ManagedWebDriverAnnotatedField webDriverField = ManagedWebDriverAnnotatedField.findFirstAnnotatedField(this.testCase.getClass());
        webDriverField.setValue(this.testCase, driver);
    }

    public boolean isUniqueSession() {
        ManagedWebDriverAnnotatedField webDriverField = ManagedWebDriverAnnotatedField.findFirstAnnotatedField(this.testCase.getClass());
        return webDriverField.isUniqueSession();
    }

    public static boolean supportsWebTests(Class clazz) {
        return Iterables.any(TestCaseAnnotations.fieldsIn(clazz), TestCaseAnnotations.isAManagedWebDriver());
    }

    private static ImmutableSet<Field> fieldsIn(Class clazz) {
        return ImmutableSet.copyOf((Object[])clazz.getDeclaredFields());
    }

    private static Predicate<Field> isAManagedWebDriver() {
        return new Predicate<Field>(){

            public boolean apply(Field field) {
                return WebDriver.class.isAssignableFrom(field.getType()) && field.getAnnotation(Managed.class) != null;
            }
        };
    }
}

