/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.runners;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.List;
import net.thucydides.core.csv.CSVTestDataSource;
import net.thucydides.junit.annotations.TestData;
import net.thucydides.junit.annotations.UseTestDataFrom;
import org.apache.commons.lang3.StringUtils;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public class DataDrivenAnnotations {
    private final TestClass testClass;

    public static DataDrivenAnnotations forClass(Class testClass) {
        return new DataDrivenAnnotations(testClass);
    }

    public static DataDrivenAnnotations forClass(TestClass testClass) {
        return new DataDrivenAnnotations(testClass);
    }

    DataDrivenAnnotations(Class testClass) {
        this(new TestClass(testClass));
    }

    DataDrivenAnnotations(TestClass testClass) {
        this.testClass = testClass;
    }

    public List<Object[]> getParametersList() throws Throwable {
        return (List)this.getTestDataMethod().getMethod().invoke(null, new Object[0]);
    }

    public FrameworkMethod getTestDataMethod() throws Exception {
        FrameworkMethod method = this.findTestDataMethod();
        if (method == null) {
            throw new IllegalArgumentException("No public static @TestDataSource method on class " + this.testClass.getName());
        }
        return method;
    }

    private FrameworkMethod findTestDataMethod() {
        List methods = this.testClass.getAnnotatedMethods(TestData.class);
        for (FrameworkMethod each : methods) {
            int modifiers = each.getMethod().getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            return each;
        }
        return null;
    }

    private String findTestDataSource() {
        String testDataSource = this.findUseTestDataFromAnnotation().value();
        String homeDir = System.getProperty("user.home");
        String userDir = System.getProperty("user.dir");
        testDataSource = StringUtils.replace((String)testDataSource, (String)"$HOME", (String)homeDir);
        testDataSource = StringUtils.replace((String)testDataSource, (String)"${HOME}", (String)homeDir);
        testDataSource = StringUtils.replace((String)testDataSource, (String)"$USERDIR", (String)userDir);
        testDataSource = StringUtils.replace((String)testDataSource, (String)"${USERDIR}", (String)userDir);
        return testDataSource;
    }

    private UseTestDataFrom findUseTestDataFromAnnotation() {
        return this.testClass.getJavaClass().getAnnotation(UseTestDataFrom.class);
    }

    public boolean hasTestDataDefined() {
        return this.findTestDataMethod() != null;
    }

    public boolean hasTestDataSourceDefined() {
        return this.findUseTestDataFromAnnotation() != null && this.findTestDataSource() != null;
    }

    public <T> List<T> getDataAsInstancesOf(Class<T> clazz) throws IOException {
        CSVTestDataSource testdata = new CSVTestDataSource(this.findTestDataSource(), this.findTestDataSeparator());
        return testdata.getDataAsInstancesOf(clazz, new Object[0]);
    }

    public int countDataEntries() throws IOException {
        CSVTestDataSource testdata = new CSVTestDataSource(this.findTestDataSource(), this.findTestDataSeparator());
        return testdata.getData().size();
    }

    private char findTestDataSeparator() {
        return this.findUseTestDataFromAnnotation().separator();
    }

    public boolean hasTestSpecificTestDataDefined() {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

