/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.runners;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.runners.model.RunnerScheduler;

class ParameterizedRunnerScheduler
implements RunnerScheduler {
    private ExecutorService executorService;
    private CompletionService<Void> completionService;
    private Queue<Future<Void>> tasks;

    public ParameterizedRunnerScheduler(Class<?> klass, int threadCount) {
        this.executorService = Executors.newFixedThreadPool(threadCount, new NamedThreadFactory(klass.getSimpleName()));
        this.completionService = new ExecutorCompletionService<Void>(this.executorService);
        this.tasks = new LinkedList<Future<Void>>();
    }

    protected Queue<Future<Void>> getTaskQueue() {
        return new LinkedList<Future<Void>>((Collection<Future<Void>>)ImmutableList.copyOf(this.tasks));
    }

    public void schedule(Runnable childStatement) {
        this.tasks.offer(this.completionService.submit(childStatement, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        try {
            while (!this.tasks.isEmpty()) {
                this.tasks.remove(this.completionService.take());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.executorService.shutdownNow();
        }
    }

    static final class NamedThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final ThreadGroup group;

        NamedThreadFactory(String poolName) {
            this.group = new ThreadGroup(poolName + "-" + POOL_NUMBER.getAndIncrement());
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(this.group, r, this.group.getName() + "-thread-" + this.threadNumber.getAndIncrement(), 0L);
        }
    }
}

