/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.runners;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.thucydides.junit.annotations.Qualifier;
import net.thucydides.junit.internals.MethodInvoker;

public class QualifierFinder {
    private final Object testCase;

    public QualifierFinder(Object testCase) {
        this.testCase = testCase;
    }

    public static QualifierFinder forTestCase(Object testCase) {
        return new QualifierFinder(testCase);
    }

    public String getQualifier() {
        if (this.hasQualifierAnnotation()) {
            String qualifierValue = (String)MethodInvoker.on(this.testCase).run(this.getQualifiedMethod(), new Object[0]);
            return qualifierValue != null ? qualifierValue : "<UNSPECIFIED>";
        }
        return this.testCase.toString();
    }

    private Method getQualifiedMethod() {
        Method[] methods;
        for (Method each : methods = this.testCase.getClass().getDeclaredMethods()) {
            if (each.getAnnotation(Qualifier.class) == null) continue;
            this.checkModifiersFor(each);
            return each;
        }
        return null;
    }

    private void checkModifiersFor(Method each) {
        int modifiers = each.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            throw new IllegalArgumentException("Qualifier method must not be static");
        }
        if (!Modifier.isPublic(modifiers)) {
            throw new IllegalArgumentException("Qualifier method must be public");
        }
        if (each.getReturnType() != String.class) {
            throw new IllegalArgumentException("Qualifier method must return a String");
        }
    }

    private boolean hasQualifierAnnotation() {
        return this.getQualifiedMethod() != null;
    }
}

