/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.listeners;

import com.google.inject.Key;
import java.io.File;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.Listeners;
import net.thucydides.core.steps.StepListener;
import net.thucydides.junit.guice.JUnitInjectors;
import net.thucydides.junit.listeners.JUnitStepListener;
import net.thucydides.junit.listeners.TestCounter;
import net.thucydides.junit.runners.ParameterizedJUnitStepListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitStepListenerBuilder {
    private final File outputDirectory;
    private final Pages pageFactory;
    private final int parameterSetNumber;
    private final DataTable parametersTable;
    private final Class<?> testClass;

    public JUnitStepListenerBuilder(File outputDirectory) {
        this(outputDirectory, null, -1, null);
    }

    public JUnitStepListenerBuilder(File outputDirectory, Pages pageFactory) {
        this(outputDirectory, pageFactory, -1, null);
    }

    public JUnitStepListenerBuilder(File outputDirectory, Pages pageFactory, int parameterSetNumber) {
        this(outputDirectory, pageFactory, parameterSetNumber, null);
    }

    public JUnitStepListenerBuilder(File outputDirectory, Pages pageFactory, int parameterSetNumber, DataTable parametersTable) {
        this(outputDirectory, pageFactory, parameterSetNumber, parametersTable, null);
    }

    public JUnitStepListenerBuilder(File outputDirectory, Pages pageFactory, int parameterSetNumber, DataTable parametersTable, Class<?> testClass) {
        this.outputDirectory = outputDirectory;
        this.pageFactory = pageFactory;
        this.parameterSetNumber = parameterSetNumber;
        this.parametersTable = parametersTable;
        this.testClass = testClass;
    }

    public JUnitStepListenerBuilder and() {
        return this;
    }

    public JUnitStepListenerBuilder withPageFactory(Pages pageFactory) {
        return new JUnitStepListenerBuilder(this.outputDirectory, pageFactory);
    }

    public JUnitStepListenerBuilder withParameterSetNumber(int parameterSetNumber) {
        return new JUnitStepListenerBuilder(this.outputDirectory, this.pageFactory, parameterSetNumber);
    }

    public JUnitStepListenerBuilder withParametersTable(DataTable parametersTable) {
        return new JUnitStepListenerBuilder(this.outputDirectory, this.pageFactory, this.parameterSetNumber, parametersTable);
    }

    public JUnitStepListenerBuilder withTestClass(Class<?> testClass) {
        return new JUnitStepListenerBuilder(this.outputDirectory, this.pageFactory, this.parameterSetNumber, this.parametersTable, testClass);
    }

    public JUnitStepListener build() {
        if (this.parameterSetNumber >= 0) {
            return this.newParameterizedJUnitStepListener();
        }
        return this.newStandardJunitStepListener();
    }

    private BaseStepListener buildBaseStepListener() {
        if (this.pageFactory != null) {
            return Listeners.getBaseStepListener().withPages(this.pageFactory).and().withOutputDirectory(this.outputDirectory);
        }
        return Listeners.getBaseStepListener().withOutputDirectory(this.outputDirectory);
    }

    private JUnitStepListener newParameterizedJUnitStepListener() {
        return new ParameterizedJUnitStepListener(this.parameterSetNumber, this.parametersTable, this.testClass, this.buildBaseStepListener(), Listeners.getLoggingListener(), this.newTestCountListener(), Listeners.getStatisticsListener());
    }

    private StepListener newTestCountListener() {
        return (StepListener)JUnitInjectors.getInjector().getInstance(Key.get(StepListener.class, TestCounter.class));
    }

    private JUnitStepListener newStandardJunitStepListener() {
        return new JUnitStepListener(this.testClass, this.buildBaseStepListener(), Listeners.getLoggingListener(), this.newTestCountListener(), Listeners.getStatisticsListener());
    }
}

