/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.runners;

import com.google.inject.Injector;
import java.io.File;
import java.util.Collection;
import java.util.List;
import net.thucydides.core.Thucydides;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.ManagedWebDriverAnnotatedField;
import net.thucydides.core.annotations.Pending;
import net.thucydides.core.annotations.TestCaseAnnotations;
import net.thucydides.core.batches.BatchManager;
import net.thucydides.core.batches.BatchStrategy;
import net.thucydides.core.batches.UnsupportedBatchStrategyException;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.ReportService;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepData;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFactory;
import net.thucydides.core.steps.StepPublisher;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.ThucydidesWebdriverManager;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebdriverManager;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import net.thucydides.junit.listeners.JUnitStepListener;
import net.thucydides.junit.runners.TestMethodAnnotations;
import net.thucydides.junit.runners.ThucydidesStatement;
import org.apache.commons.lang3.StringUtils;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThucydidesRunner
extends BlockJUnit4ClassRunner {
    private StepFactory stepFactory;
    private Pages pages;
    private final WebdriverManager webdriverManager;
    private String requestedDriver;
    private ReportService reportService;
    private JUnitStepListener stepListener;
    private Configuration configuration;
    private boolean uniqueSession;
    private BatchManager batchManager;
    private final Logger logger = LoggerFactory.getLogger(ThucydidesRunner.class);

    public Pages getPages() {
        return this.pages;
    }

    public ThucydidesRunner(Class<?> klass) throws InitializationError {
        this(klass, Injectors.getInjector());
    }

    public ThucydidesRunner(Class<?> klass, Injector injector) throws InitializationError {
        this(klass, (WebdriverManager)injector.getInstance(WebdriverManager.class), (Configuration)injector.getInstance(Configuration.class), ThucydidesRunner.getBatchManager((Configuration)injector.getInstance(Configuration.class)));
    }

    public ThucydidesRunner(Class<?> klass, WebDriverFactory webDriverFactory) throws InitializationError {
        this(klass, webDriverFactory, (Configuration)Injectors.getInjector().getInstance(Configuration.class));
    }

    public ThucydidesRunner(Class<?> klass, WebDriverFactory webDriverFactory, Configuration configuration) throws InitializationError {
        this(klass, (WebdriverManager)new ThucydidesWebdriverManager(webDriverFactory, configuration), configuration, ThucydidesRunner.getBatchManager(configuration));
    }

    public ThucydidesRunner(Class<?> klass, BatchManager batchManager) throws InitializationError {
        this(klass, (WebdriverManager)Injectors.getInjector().getInstance(WebdriverManager.class), (Configuration)Injectors.getInjector().getInstance(Configuration.class), batchManager);
    }

    public ThucydidesRunner(Class<?> klass, WebdriverManager webDriverManager, Configuration configuration, BatchManager batchManager) throws InitializationError {
        super(klass);
        this.webdriverManager = webDriverManager;
        this.configuration = configuration;
        this.requestedDriver = this.getSpecifiedDriver(klass);
        if (TestCaseAnnotations.supportsWebTests(klass)) {
            this.checkRequestedDriverType();
        }
        this.batchManager = batchManager;
        batchManager.registerTestCase(klass);
    }

    private String getSpecifiedDriver(Class<?> klass) {
        if (ManagedWebDriverAnnotatedField.hasManagedWebdriverField(klass)) {
            return ManagedWebDriverAnnotatedField.findFirstAnnotatedField(klass).getDriver();
        }
        return null;
    }

    private static BatchManager getBatchManager(Configuration configuration) {
        EnvironmentVariables environmentVariables = configuration.getEnvironmentVariables();
        String batchManagerProperty = ThucydidesSystemProperty.BATCH_STRATEGY.from(environmentVariables, BatchStrategy.DIVIDE_EQUALLY.name());
        try {
            return BatchStrategy.valueOf((String)batchManagerProperty).instance(environmentVariables);
        }
        catch (Exception e) {
            throw new UnsupportedBatchStrategyException(batchManagerProperty + " is not a supported batch strategy.", e);
        }
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected BatchManager getBatchManager() {
        return this.batchManager;
    }

    private void checkRequestedDriverType() {
        if (this.requestedDriverSpecified()) {
            SupportedWebDriver.getDriverTypeFor((String)this.requestedDriver);
        } else {
            this.getConfiguration().getDriverType();
        }
    }

    private boolean requestedDriverSpecified() {
        return !StringUtils.isEmpty((CharSequence)this.requestedDriver);
    }

    public File getOutputDirectory() {
        return this.getConfiguration().getOutputDirectory();
    }

    public void subscribeReporter(AcceptanceTestReporter reporter) {
        this.getReportService().subscribe(reporter);
    }

    public void useQualifier(String qualifier) {
        this.getReportService().useQualifier(qualifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        if (!this.skipThisTest()) {
            try {
                this.initializeDriversAndListeners(notifier);
                super.run(notifier);
            }
            finally {
                this.notifyTestSuiteFinished();
                this.generateReports();
                this.dropListeners(notifier);
                this.closeDrivers();
            }
        }
    }

    private void notifyTestSuiteFinished() {
        try {
            StepEventBus.getEventBus().testSuiteFinished();
        }
        catch (Throwable listenerException) {
            this.logger.error("Test event bus error: " + listenerException.getMessage(), listenerException);
        }
    }

    private void dropListeners(RunNotifier notifier) {
        JUnitStepListener listener = this.getStepListener();
        notifier.removeListener((RunListener)listener);
        this.getStepListener().dropListeners();
    }

    protected void generateReports() {
        this.generateReportsFor(this.getTestOutcomes());
    }

    private boolean skipThisTest() {
        return this.batchManager != null && !this.batchManager.shouldExecuteThisTest(this.getDescription().testCount());
    }

    protected JUnitStepListener getStepListener() {
        if (this.stepListener == null) {
            this.buildAndConfigureListeners();
        }
        return this.stepListener;
    }

    protected void setStepListener(JUnitStepListener stepListener) {
        this.stepListener = stepListener;
    }

    private void buildAndConfigureListeners() {
        this.initStepEventBus();
        if (this.webtestsAreSupported()) {
            this.initPagesObjectUsing(this.webdriverManager.getWebdriver(this.requestedDriver));
            this.setStepListener(this.initListenersUsing(this.getPages()));
            this.initStepFactoryUsing(this.getPages());
        } else {
            this.setStepListener(this.initListeners());
            this.initStepFactory();
        }
    }

    private void initializeDriversAndListeners(RunNotifier notifier) {
        JUnitStepListener listener = this.getStepListener();
        notifier.addListener((RunListener)listener);
    }

    protected void initStepEventBus() {
        StepEventBus.getEventBus().clear();
    }

    private void initPagesObjectUsing(WebDriver driver) {
        this.pages = new Pages(driver, this.getConfiguration());
    }

    protected JUnitStepListener initListenersUsing(Pages pageFactory) {
        return JUnitStepListener.withOutputDirectory(this.getConfiguration().getOutputDirectory()).and().withPageFactory(pageFactory).and().withTestClass(this.getTestClass().getJavaClass()).and().build();
    }

    protected JUnitStepListener initListeners() {
        return JUnitStepListener.withOutputDirectory(this.getConfiguration().getOutputDirectory()).and().withTestClass(this.getTestClass().getJavaClass()).and().build();
    }

    private boolean webtestsAreSupported() {
        return TestCaseAnnotations.supportsWebTests((Class)this.getTestClass().getJavaClass());
    }

    private void initStepFactoryUsing(Pages pagesObject) {
        this.stepFactory = new StepFactory(pagesObject);
    }

    private void initStepFactory() {
        this.stepFactory = new StepFactory();
    }

    private void closeDrivers() {
        this.getWebdriverManager().closeAllCurrentDrivers();
    }

    protected WebdriverManager getWebdriverManager() {
        return this.webdriverManager;
    }

    private ReportService getReportService() {
        if (this.reportService == null) {
            this.reportService = new ReportService(this.getOutputDirectory(), this.getDefaultReporters());
        }
        return this.reportService;
    }

    private void generateReportsFor(List<TestOutcome> testOutcomeResults) {
        this.getReportService().generateReportsFor(testOutcomeResults);
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        Thucydides.initializeTestSession();
        this.resetBroswerFromTimeToTime();
        if (this.isPending(method)) {
            this.markAsPending(method);
            notifier.fireTestIgnored(this.describeChild(method));
        } else {
            this.processTestMethodAnnotationsFor(method);
            super.runChild(method, notifier);
        }
    }

    private void markAsPending(FrameworkMethod method) {
        this.stepListener.testStarted(Description.createTestDescription(method.getMethod().getDeclaringClass(), (String)this.testName(method)));
        StepEventBus.getEventBus().testPending();
        StepEventBus.getEventBus().testFinished();
    }

    private void processTestMethodAnnotationsFor(FrameworkMethod method) {
        if (this.isIgnored(method)) {
            this.stepListener.testStarted(Description.createTestDescription(method.getMethod().getDeclaringClass(), (String)this.testName(method)));
            StepEventBus.getEventBus().testIgnored();
        }
    }

    private boolean isPending(FrameworkMethod method) {
        return method.getAnnotation(Pending.class) != null;
    }

    private boolean isIgnored(FrameworkMethod method) {
        return method.getAnnotation(Ignore.class) != null;
    }

    protected boolean restartBrowserBeforeTest() {
        return !this.uniqueSession;
    }

    protected boolean isUniqueSession() {
        return this.uniqueSession;
    }

    protected void resetBroswerFromTimeToTime() {
        if (this.restartBrowserBeforeTest()) {
            WebdriverProxyFactory.resetDriver((WebDriver)this.getDriver());
        }
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        if (this.webtestsAreSupported()) {
            this.injectDriverInto(test, method);
            this.initPagesObjectUsing(this.driverFor(method));
            this.injectAnnotatedPagesObjectInto(test);
            this.initStepFactoryUsing(this.getPages());
            this.uniqueSession = TestCaseAnnotations.forTestCase((Object)test).isUniqueSession();
        }
        this.injectScenarioStepsInto(test);
        this.useStepFactoryForDataDrivenSteps();
        Statement baseStatement = super.methodInvoker(method, test);
        return new ThucydidesStatement(baseStatement, (StepPublisher)this.stepListener.getBaseStepListener());
    }

    private void useStepFactoryForDataDrivenSteps() {
        StepData.setDefaultStepFactory((StepFactory)this.stepFactory);
    }

    protected void injectDriverInto(Object testCase, FrameworkMethod method) {
        TestCaseAnnotations.forTestCase((Object)testCase).injectDriver(this.driverFor(method));
    }

    protected WebDriver driverFor(FrameworkMethod method) {
        if (TestMethodAnnotations.forTest(method).isDriverSpecified()) {
            String testSpecificDriver = TestMethodAnnotations.forTest(method).specifiedDriver();
            return this.getDriver(testSpecificDriver);
        }
        return this.getDriver();
    }

    protected void injectScenarioStepsInto(Object testCase) {
        StepAnnotations.injectScenarioStepsInto((Object)testCase, (StepFactory)this.stepFactory);
    }

    protected void injectAnnotatedPagesObjectInto(Object testCase) {
        StepAnnotations.injectAnnotatedPagesObjectInto((Object)testCase, (Pages)this.pages);
    }

    protected WebDriver getDriver() {
        return this.getWebdriverManager().getWebdriver(this.requestedDriver);
    }

    protected WebDriver getDriver(String driver) {
        return this.getWebdriverManager().getWebdriver(driver);
    }

    public List<TestOutcome> getTestOutcomes() {
        return this.getStepListener().getTestOutcomes();
    }

    protected Collection<AcceptanceTestReporter> getDefaultReporters() {
        return ReportService.getDefaultReporters();
    }
}

