/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.runners;

import java.util.List;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.DataTableRow;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.junit.listeners.JUnitStepListener;
import net.thucydides.junit.runners.DataDrivenAnnotations;
import net.thucydides.junit.runners.ThucydidesRunner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestClassRunnerForParameters
extends ThucydidesRunner {
    private final int parameterSetNumber;
    private final DataTable parametersTable;

    TestClassRunnerForParameters(Class<?> type, Configuration configuration, WebDriverFactory webDriverFactory, DataTable parametersTable, int i) throws InitializationError {
        super(type, webDriverFactory, configuration);
        this.parametersTable = parametersTable;
        this.parameterSetNumber = i;
    }

    @Override
    protected JUnitStepListener initListenersUsing(Pages pageFactory) {
        this.setStepListener(JUnitStepListener.withOutputDirectory(this.getConfiguration().getOutputDirectory()).and().withPageFactory(pageFactory).and().withParameterSetNumber(this.parameterSetNumber).and().withParametersTable(this.parametersTable).and().withTestClass(this.getTestClass().getJavaClass()).and().build());
        return this.getStepListener();
    }

    public Object createTest() throws Exception {
        return this.getTestClass().getOnlyConstructor().newInstance(this.computeParams());
    }

    private Object[] computeParams() throws Exception {
        try {
            DataTableRow row = (DataTableRow)this.parametersTable.getRows().get(this.parameterSetNumber);
            return row.getValues().toArray();
        }
        catch (ClassCastException cause) {
            throw new Exception(String.format("%s.%s() must return a Collection of arrays.", this.getTestClass().getName(), DataDrivenAnnotations.forClass(this.getTestClass()).getTestDataMethod().getName()), cause);
        }
    }

    @Override
    protected boolean restartBrowserBeforeTest() {
        if (this.isUniqueSession()) {
            return false;
        }
        int restartFrequency = this.getConfiguration().getRestartFrequency();
        return restartFrequency > 0 && this.parameterSetNumber > 0 && this.parameterSetNumber % restartFrequency == 0;
    }

    protected String getName() {
        String firstParameter = ((DataTableRow)this.parametersTable.getRows().get(this.parameterSetNumber)).getValues().get(0).toString();
        return String.format("[%s]", firstParameter);
    }

    protected String testName(FrameworkMethod method) {
        return String.format("%s[%s]", method.getName(), this.parameterSetNumber);
    }

    protected void validateConstructor(List<Throwable> errors) {
        this.validateOnlyOneConstructor(errors);
    }

    protected Statement classBlock(RunNotifier notifier) {
        return this.childrenInvoker(notifier);
    }

    @Override
    protected void generateReports() {
    }
}

