/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.finder;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.extcos.ComponentQuery;
import net.sf.extcos.ComponentScanner;
import net.thucydides.junit.annotations.UseTestDataFrom;
import net.thucydides.junit.finder.TestFinderBuilderFactory;
import net.thucydides.junit.finder.TestMethodFinder;
import net.thucydides.junit.runners.ThucydidesRunner;
import org.junit.Test;
import org.junit.runner.RunWith;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestFinder {
    protected final String rootPackage;

    protected TestFinder(String rootPackage) {
        this.rootPackage = rootPackage;
    }

    public static TestFinderBuilderFactory thatFinds() {
        return new TestFinderBuilderFactory();
    }

    public abstract List<Class<?>> getClasses();

    public abstract int countTestMethods();

    public TestMethodFinder findTestMethods() {
        return new TestMethodFinder(this);
    }

    protected Set<Class<?>> getAllTestClasses() {
        ComponentScanner scanner = new ComponentScanner();
        return scanner.getClasses(new ComponentQuery(){

            protected void query() {
                this.select().from(new String[]{TestFinder.this.rootPackage}).returning(this.allAnnotatedWith(RunWith.class));
            }
        });
    }

    protected Set<Class<?>> getNormalTestClasses() {
        HashSet normalTestClasses = Sets.newHashSet();
        for (Class<?> testClass : this.getAllTestClasses()) {
            if (!this.normalThucydidesTest(testClass)) continue;
            normalTestClasses.add(testClass);
        }
        return normalTestClasses;
    }

    protected Set<Class<?>> getDataDrivenTestClasses() {
        ComponentScanner scanner = new ComponentScanner();
        return scanner.getClasses(new ComponentQuery(){

            protected void query() {
                this.select().from(new String[]{TestFinder.this.rootPackage}).returning(this.allAnnotatedWith(UseTestDataFrom.class));
            }
        });
    }

    protected List<Class<?>> sorted(List<Class<?>> classes) {
        Collections.sort(classes, this.byClassName());
        return classes;
    }

    private boolean normalThucydidesTest(Class<?> testClass) {
        RunWith runWith = testClass.getAnnotation(RunWith.class);
        return runWith != null && runWith.value() == ThucydidesRunner.class;
    }

    public List<Method> getAllTestMethods() {
        return this.findMethodsFrom(this.getClasses());
    }

    private List<Method> findMethodsFrom(List<Class<?>> testClasses) {
        ArrayList methods = Lists.newArrayList();
        for (Class<?> testClass : testClasses) {
            this.addEachMatchingTestMethodFrom(testClass).to(methods);
        }
        Collections.sort(methods, this.byName());
        return methods;
    }

    private Comparator<Method> byName() {
        return new Comparator<Method>(){

            @Override
            public int compare(Method method, Method method1) {
                return method.getName().compareTo(method1.getName());
            }
        };
    }

    private TestMethodSearchBuilder addEachMatchingTestMethodFrom(Class<?> testClass) {
        return new TestMethodSearchBuilder(testClass);
    }

    private Comparator<Class<?>> byClassName() {
        return new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> class1, Class<?> class2) {
                return class1.getName().compareTo(class2.getName());
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestMethodSearchBuilder {
        private final Class<?> testClass;

        private TestMethodSearchBuilder(Class<?> testClass) {
            this.testClass = testClass;
        }

        public void to(List<Method> methods) {
            for (Method method : this.testClass.getMethods()) {
                if (!method.isAnnotationPresent(Test.class)) continue;
                methods.add(method);
            }
        }
    }
}

