/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.runners;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import net.thucydides.core.csv.CSVTestDataSource;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.steps.FilePathParser;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.junit.annotations.TestData;
import net.thucydides.junit.annotations.UseTestDataFrom;
import org.apache.commons.lang3.StringUtils;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public class DataDrivenAnnotations {
    private final EnvironmentVariables environmentVariables;
    private final Pattern DATASOURCE_PATH_SEPARATORS = Pattern.compile("[;,]");
    private final TestClass testClass;

    public static DataDrivenAnnotations forClass(Class testClass) {
        return new DataDrivenAnnotations(testClass);
    }

    public static DataDrivenAnnotations forClass(TestClass testClass) {
        return new DataDrivenAnnotations(testClass);
    }

    DataDrivenAnnotations(Class testClass) {
        this(new TestClass(testClass));
    }

    DataDrivenAnnotations(TestClass testClass) {
        this(testClass, (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    DataDrivenAnnotations(TestClass testClass, EnvironmentVariables environmentVariables) {
        this.testClass = testClass;
        this.environmentVariables = environmentVariables;
    }

    DataDrivenAnnotations usingEnvironmentVariables(EnvironmentVariables environmentVariables) {
        return new DataDrivenAnnotations(this.testClass, environmentVariables);
    }

    public DataTable getParametersTableFromTestDataSource() throws Throwable {
        CSVTestDataSource testDataSource = new CSVTestDataSource(this.findTestDataSource(), this.findTestDataSeparator());
        List testData = testDataSource.getData();
        List headers = testDataSource.getHeaders();
        return DataTable.withHeaders((List)headers).andMappedRows(testData).build();
    }

    public DataTable getParametersTableFromTestDataAnnotation() {
        Method testDataMethod = null;
        String columnNamesString = null;
        List parametersList = null;
        try {
            testDataMethod = this.getTestDataMethod().getMethod();
            columnNamesString = testDataMethod.getAnnotation(TestData.class).columnNames();
            parametersList = (List)testDataMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not obtain test data from the test class", e);
        }
        return this.createParametersTableFrom(columnNamesString, Lambda.convert((Object)parametersList, this.toListOfObjects()));
    }

    private Converter<Object[], List<Object>> toListOfObjects() {
        return new Converter<Object[], List<Object>>(){

            public List<Object> convert(Object[] parameters) {
                return Arrays.asList(parameters);
            }
        };
    }

    private DataTable createParametersTableFrom(String columnNamesString, List<List<Object>> parametersList) {
        int numberOfColumns = parametersList.isEmpty() ? 0 : parametersList.get(0).size();
        List<String> columnNames = this.split(columnNamesString, numberOfColumns);
        return DataTable.withHeaders(columnNames).andRows(parametersList).build();
    }

    private List<String> split(String columnNamesString, int numberOfColumns) {
        String[] columnNames = new String[numberOfColumns];
        if (columnNamesString.equals("")) {
            for (int i = 0; i < numberOfColumns; ++i) {
                columnNames[i] = "Parameter " + (i + 1);
            }
        } else {
            columnNames = StringUtils.split((String)columnNamesString, (String)",", (int)numberOfColumns);
        }
        return Arrays.asList(columnNames);
    }

    public FrameworkMethod getTestDataMethod() throws Exception {
        FrameworkMethod method = this.findTestDataMethod();
        if (method == null) {
            throw new IllegalArgumentException("No public static @FilePathParser method on class " + this.testClass.getName());
        }
        return method;
    }

    private FrameworkMethod findTestDataMethod() {
        List methods = this.testClass.getAnnotatedMethods(TestData.class);
        for (FrameworkMethod each : methods) {
            int modifiers = each.getMethod().getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            return each;
        }
        return null;
    }

    protected String findTestDataSource() {
        String paths = this.findTestDataSourcePaths();
        for (String path : Splitter.on((Pattern)this.DATASOURCE_PATH_SEPARATORS).split((CharSequence)paths)) {
            if (!CSVTestDataSource.validTestDataPath((String)path)) continue;
            return path;
        }
        throw new IllegalArgumentException("No test data file found for path: " + paths);
    }

    protected String findTestDataSourcePaths() {
        return new FilePathParser(this.environmentVariables).getInstanciatedPath(this.findUseTestDataFromAnnotation().value());
    }

    private UseTestDataFrom findUseTestDataFromAnnotation() {
        return this.testClass.getJavaClass().getAnnotation(UseTestDataFrom.class);
    }

    public boolean hasTestDataDefined() {
        return this.findTestDataMethod() != null;
    }

    public boolean hasTestDataSourceDefined() {
        return this.findUseTestDataFromAnnotation() != null && this.findTestDataSource() != null;
    }

    public <T> List<T> getDataAsInstancesOf(Class<T> clazz) throws IOException {
        CSVTestDataSource testdata = new CSVTestDataSource(this.findTestDataSource(), this.findTestDataSeparator());
        return testdata.getDataAsInstancesOf(clazz, new Object[0]);
    }

    public int countDataEntries() throws IOException {
        CSVTestDataSource testdata = new CSVTestDataSource(this.findTestDataSource(), this.findTestDataSeparator());
        return testdata.getData().size();
    }

    private char findTestDataSeparator() {
        return this.findUseTestDataFromAnnotation().separator();
    }
}

