/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.runners;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.thucydides.core.batches.BatchManager;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.DataTableRow;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.ReportService;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.junit.annotations.Concurrent;
import net.thucydides.junit.runners.DataDrivenAnnotations;
import net.thucydides.junit.runners.ParameterizedRunnerScheduler;
import net.thucydides.junit.runners.ParameterizedTestsOutcomeAggregator;
import net.thucydides.junit.runners.QualifierFinder;
import net.thucydides.junit.runners.TestClassRunnerForInstanciatedTestCase;
import net.thucydides.junit.runners.TestClassRunnerForParameters;
import net.thucydides.junit.runners.ThucydidesRunner;
import org.apache.commons.lang3.StringUtils;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;

public class ThucydidesParameterizedRunner
extends Suite {
    private static final int AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
    private final List<Runner> runners = new ArrayList<Runner>();
    private final Configuration configuration;
    private ReportService reportService;
    private final ParameterizedTestsOutcomeAggregator parameterizedTestsOutcomeAggregator = ParameterizedTestsOutcomeAggregator.from(this);

    public ThucydidesParameterizedRunner(Class<?> klass, Configuration configuration, WebDriverFactory webDriverFactory, BatchManager batchManager) throws Throwable {
        super(klass, Collections.emptyList());
        DataDrivenAnnotations testClassAnnotations;
        this.configuration = configuration;
        if (this.runTestsInParallelFor(klass)) {
            this.scheduleParallelTestRunsFor(klass);
        }
        if ((testClassAnnotations = this.getTestAnnotations()).hasTestDataDefined()) {
            this.buildTestRunnersForEachDataSetUsing(webDriverFactory, batchManager);
        } else if (testClassAnnotations.hasTestDataSourceDefined()) {
            this.buildTestRunnersFromADataSourceUsing(webDriverFactory, batchManager);
        }
    }

    private void scheduleParallelTestRunsFor(Class<?> klass) {
        this.setScheduler(new ParameterizedRunnerScheduler(klass, this.getThreadCountFor(klass)));
    }

    protected boolean runTestsInParallelFor(Class<?> klass) {
        return klass.getAnnotation(Concurrent.class) != null;
    }

    protected int getThreadCountFor(Class<?> klass) {
        Concurrent concurrent = klass.getAnnotation(Concurrent.class);
        String threadValue = concurrent.threads();
        int threads = AVAILABLE_PROCESSORS * 2;
        if (StringUtils.isNotEmpty((CharSequence)threadValue)) {
            if (StringUtils.isNumeric((CharSequence)threadValue)) {
                threads = Integer.valueOf(threadValue);
            } else if (threadValue.endsWith("x")) {
                threads = this.getRelativeThreadCount(threadValue);
            }
        }
        return threads;
    }

    private int getRelativeThreadCount(String threadValue) {
        try {
            String threadCount = threadValue.substring(0, threadValue.length() - 1);
            return Integer.valueOf(threadCount) * AVAILABLE_PROCESSORS;
        }
        catch (NumberFormatException cause) {
            throw new IllegalArgumentException("Illegal thread value: " + threadValue, cause);
        }
    }

    private void buildTestRunnersForEachDataSetUsing(WebDriverFactory webDriverFactory, BatchManager batchManager) throws Throwable {
        DataTable parametersTable = this.getTestAnnotations().getParametersTableFromTestDataAnnotation();
        int i = 0;
        while (i < parametersTable.getRows().size()) {
            Class testClass = this.getTestClass().getJavaClass();
            TestClassRunnerForParameters runner = new TestClassRunnerForParameters(testClass, this.configuration, webDriverFactory, batchManager, parametersTable, i);
            ((ThucydidesRunner)runner).useQualifier(this.from(((DataTableRow)parametersTable.getRows().get(i)).getValues()));
            this.runners.add((Runner)runner);
            ++i;
        }
    }

    private void buildTestRunnersFromADataSourceUsing(WebDriverFactory webDriverFactory, BatchManager batchManager) throws Throwable {
        List testCases = this.getTestAnnotations().getDataAsInstancesOf(this.getTestClass().getJavaClass());
        DataTable parametersTable = this.getTestAnnotations().getParametersTableFromTestDataSource();
        int i = 0;
        while (i < testCases.size()) {
            Object testCase = testCases.get(i);
            TestClassRunnerForInstanciatedTestCase runner = new TestClassRunnerForInstanciatedTestCase(testCase, this.configuration, webDriverFactory, batchManager, parametersTable, i);
            runner.useQualifier(this.getQualifierFor(testCase));
            this.runners.add((Runner)runner);
            ++i;
        }
    }

    private String getQualifierFor(Object testCase) {
        return QualifierFinder.forTestCase(testCase).getQualifier();
    }

    private DataDrivenAnnotations getTestAnnotations() {
        return DataDrivenAnnotations.forClass(this.getTestClass());
    }

    private String from(Collection testData) {
        StringBuffer testDataQualifier = new StringBuffer();
        boolean firstEntry = true;
        for (Object testDataValue : testData) {
            if (!firstEntry) {
                testDataQualifier.append("/");
            }
            testDataQualifier.append(testDataValue);
            firstEntry = false;
        }
        return testDataQualifier.toString();
    }

    public ThucydidesParameterizedRunner(Class<?> klass) throws Throwable {
        this(klass, (Configuration)Injectors.getInjector().getInstance(Configuration.class), new WebDriverFactory(), (BatchManager)Injectors.getInjector().getInstance(BatchManager.class));
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    public void run(RunNotifier notifier) {
        try {
            super.run(notifier);
        }
        finally {
            this.generateReports();
        }
    }

    public void generateReports() {
        this.generateReportsFor(this.parameterizedTestsOutcomeAggregator.aggregateTestOutcomesByTestMethods());
    }

    private void generateReportsFor(List<TestOutcome> testOutcomes) {
        this.getReportService().generateReportsFor(testOutcomes);
    }

    private ReportService getReportService() {
        if (this.reportService == null) {
            this.reportService = new ReportService(this.getOutputDirectory(), this.getDefaultReporters());
        }
        return this.reportService;
    }

    private Collection<AcceptanceTestReporter> getDefaultReporters() {
        return ReportService.getDefaultReporters();
    }

    private File getOutputDirectory() {
        return this.configuration.getOutputDirectory();
    }

    public void subscribeReporter(AcceptanceTestReporter reporter) {
        this.getReportService().subscribe(reporter);
    }

    public List<Runner> getRunners() {
        return this.runners;
    }
}

