/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.runners;

import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.StepListener;
import net.thucydides.junit.listeners.JUnitStepListener;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;

public class ParameterizedJUnitStepListener
extends JUnitStepListener {
    final int parameterSetNumber;

    public ParameterizedJUnitStepListener(int parameterSetNumber, BaseStepListener baseStepListener, StepListener ... listeners) {
        super(baseStepListener, listeners);
        this.parameterSetNumber = parameterSetNumber;
    }

    public void testStarted(Description description) {
        if (this.testingThisDataSet(description)) {
            super.testStarted(description);
        }
    }

    private boolean testingThisDataSet(Description description) {
        return description.getMethodName().endsWith("[" + this.parameterSetNumber + "]");
    }

    public void testFinished(Description description) throws Exception {
        if (this.testingThisDataSet(description)) {
            super.testFinished(description);
        }
    }

    public void testFailure(Failure failure) throws Exception {
        if (this.testingThisDataSet(failure.getDescription())) {
            super.testFailure(failure);
        }
    }

    public void testIgnored(Description description) throws Exception {
        if (this.testingThisDataSet(description)) {
            super.testIgnored(description);
        }
    }
}

