/*
 * Licensed by the author of Time4J-project.
 *
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership. The copyright owner
 * licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package net.time4j.tz;


/**
 * <p>Identifies a timezone. </p>
 *
 * <p>In most cases, the timezone ID has the Olson-format
 * &quot;{region}/{city}&quot; or is an offset in the format
 * &quot;UTC&#x00B1;hh:mm&quot;. In latter case applications can
 * instead directly use an instance of type {@code ZonalOffset},
 * especially if the timezone offset for a given timepoint is
 * already known. </p>
 *
 * <p><strong>Provider-specific keys</strong> have the
 * {@link ZoneModelProvider#getName() name} of the provider followed by the
 * separator char &quot;~&quot; and the normal canonical identifier. This
 * form can be used if a custom registered {@link ZoneModelProvider} shall be
 * used instead of the default provider for lookup of the zonal data. For
 * example following key will search the timezone data via the API of
 * {@code java.util.TimeZone} even if there is configured another default
 * zone provider: &quot;java.util.TimeZone~Europe/Berlin&quot; </p>
 *
 * <p>Lexical comparisons of IDs should always be done by the method
 * {@link #canonical()} because an object of type {@code TZID} is only
 * designed for encapsulating a canonical name. <strong>The comparison
 * using the method {@code equals()} is not allowed. </strong></p>
 *
 * <p>If a timezone offset is known for historical timezones before the year
 * 1970 then users should generally prefer the class {@code ZonalOffset} because
 * the timezone data associated with the enum constants are not necessarily
 * correct. </p>
 *
 * <p><strong>Specification:</strong>
 * All implementations must be immutable, thread-safe and serializable. </p>
 *
 * @author  Meno Hochschild
 */
/*[deutsch]
 * <p>Identifiziert eine Zeitzone. </p>
 *
 * <p>Meistens liegt die ID im Olson-Format &quot;{region}/{city}&quot; oder
 * als Offset-Angabe im Format &quot;UTC&#x00B1;hh:mm&quot; vor. In letzterem
 * Fall kann und sollte auch direkt ein Objekt des Typs {@code ZonalOffset}
 * in Betracht gezogen werden, insbesondere dann, wenn eine Verschiebung
 * zu einem gegebenen Zeitpunkt schon bekannt ist. </p>
 *
 * <p><strong>Provider-spezifische Schl&uuml;ssel</strong> haben den
 * {@link ZoneModelProvider#getName() Namen} des {@code ZoneModelProvider} gefolgt
 * von der Tilde &quot;~&quot; und der normalen kanonischen ID. Diese
 * Form kann verwendet werden, wenn ein registrierter benutzerdefinierter
 * {@link ZoneModelProvider} an Stelle des Standard-Provider f&uuml;r die
 * Suche nach den Zeitzonendaten herangezogen werden soll. Zum Beispiel
 * wird folgender Schl&uuml;ssel die Zeitzonendaten &uuml;ber das API von
 * {@code java.util.TimeZone} suchen, sogar wenn ein anderer Standard-Provider
 * eingestellt ist:
 * &quot;java.util.TimeZone~Europe/Berlin&quot; </p>
 *
 * <p>Ein (lexikalischer) Vergleich von IDs sollte immer &uuml;ber die Methode
 * {@link #canonical()} gemacht werden, weil ein {@code TZID} nur dem Zweck
 * dient, einen kanonischen Namen zu kapseln. <strong>Der Vergleich &uuml;ber
 * die Objekt-Methode {@code equals()} ist nicht erlaubt. </strong></p>
 *
 * <p>Falls f&uuml;r historische Zeitangaben vor dem Jahr 1970 ein Offset
 * wohlbekannt ist, ist generell der Klasse {@code ZonalOffset} der Vorzug
 * vor den Enum-Konstanten zu geben, weil die mit den Enums verkn&uuml;pften
 * historischen Zeitzonendaten nicht notwendig korrekt sein m&uuml;ssen. </p>
 *
 * <p><strong>Specification:</strong>
 * All implementations must be immutable, thread-safe and serializable. </p>
 *
 * @author  Meno Hochschild
 */
public interface TZID {

    //~ Methoden ----------------------------------------------------------

    /**
     * <p>Represents the full canonical name of a timezone (for
     * example &quot;Europe/Paris&quot; or &quot;UTC+01:00&quot;). </p>
     *
     * @return  String in TZDB format (Olson-ID) or in canonical offset format
     */
    /*[deutsch]
     * <p>Repr&auml;sentiert den vollst&auml;ndigen kanonischen Namen
     * einer Zeitzone (zum Beispiel &quot;Europe/Paris&quot; oder
     * &quot;UTC+01:00&quot;). </p>
     *
     * @return  String in TZDB format (Olson-ID) or in canonical offset format
     */
    String canonical();

}
