/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.time4j.GeneralTimestamp;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.SystemClock;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.calendar.CommonElements;
import net.time4j.calendar.EraYearMonthDaySystem;
import net.time4j.calendar.IndianEra;
import net.time4j.calendar.IndianMonth;
import net.time4j.calendar.OrdinalWeekdayElement;
import net.time4j.calendar.RelatedGregorianYearRule;
import net.time4j.calendar.StdCalendarElement;
import net.time4j.calendar.WeekdayInMonthElement;
import net.time4j.calendar.WeekdayRule;
import net.time4j.calendar.service.GenericDatePatterns;
import net.time4j.calendar.service.StdEnumDateElement;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.calendar.service.StdWeekdayElement;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoFunction;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.Chronology;
import net.time4j.engine.DisplayStyle;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.IntElementRule;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.UnitRule;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

@CalendarType(value="indian")
public final class IndianCalendar
extends Calendrical<Unit, IndianCalendar>
implements LocalizedPatternSupport {
    private static final int MAX_YEAR = 999999921;
    private static final int YEAR_INDEX = 0;
    private static final int DAY_OF_MONTH_INDEX = 2;
    private static final int DAY_OF_YEAR_INDEX = 3;
    @FormattableElement(format="G")
    public static final ChronoElement<IndianEra> ERA = new StdEnumDateElement<IndianEra, IndianCalendar>("ERA", IndianCalendar.class, IndianEra.class, 'G');
    @FormattableElement(format="y")
    public static final StdCalendarElement<Integer, IndianCalendar> YEAR_OF_ERA = new StdIntegerDateElement<IndianCalendar>("YEAR_OF_ERA", IndianCalendar.class, 1, 999999921, 'y', null, null);
    @FormattableElement(format="M", standalone="L")
    public static final StdCalendarElement<IndianMonth, IndianCalendar> MONTH_OF_YEAR = new StdEnumDateElement<IndianMonth, IndianCalendar>("MONTH_OF_YEAR", IndianCalendar.class, IndianMonth.class, 'M');
    @FormattableElement(format="d")
    public static final StdCalendarElement<Integer, IndianCalendar> DAY_OF_MONTH = new StdIntegerDateElement<IndianCalendar>("DAY_OF_MONTH", IndianCalendar.class, 1, 31, 'd');
    @FormattableElement(format="D")
    public static final StdCalendarElement<Integer, IndianCalendar> DAY_OF_YEAR = new StdIntegerDateElement<IndianCalendar>("DAY_OF_YEAR", IndianCalendar.class, 1, 365, 'D');
    @FormattableElement(format="E")
    public static final StdCalendarElement<Weekday, IndianCalendar> DAY_OF_WEEK = new StdWeekdayElement<IndianCalendar>(IndianCalendar.class, IndianCalendar.getDefaultWeekmodel());
    private static final WeekdayInMonthElement<IndianCalendar> WIM_ELEMENT = new WeekdayInMonthElement<IndianCalendar>(IndianCalendar.class, DAY_OF_MONTH, DAY_OF_WEEK);
    @FormattableElement(format="F")
    public static final OrdinalWeekdayElement<IndianCalendar> WEEKDAY_IN_MONTH = WIM_ELEMENT;
    private static final EraYearMonthDaySystem<IndianCalendar> CALSYS = new Transformer();
    private static final TimeAxis<Unit, IndianCalendar> ENGINE;
    private static final long serialVersionUID = 7482205842000661998L;
    private final transient int iyear;
    private final transient int imonth;
    private final transient int idom;

    private IndianCalendar(int n, int n2, int n3) {
        this.iyear = n;
        this.imonth = n2;
        this.idom = n3;
    }

    public static IndianCalendar of(int n, IndianMonth indianMonth, int n2) {
        return IndianCalendar.of(n, indianMonth.getValue(), n2);
    }

    public static IndianCalendar of(int n, int n2, int n3) {
        if (!CALSYS.isValid(IndianEra.SAKA, n, n2, n3)) {
            throw new IllegalArgumentException("Invalid Indian date: year=" + n + ", month=" + n2 + ", day=" + n3);
        }
        return new IndianCalendar(n, n2, n3);
    }

    public static IndianCalendar nowInSystemTime() {
        return (IndianCalendar)SystemClock.inLocalView().now(IndianCalendar.axis());
    }

    public IndianEra getEra() {
        return IndianEra.SAKA;
    }

    public int getYear() {
        return this.iyear;
    }

    public IndianMonth getMonth() {
        return IndianMonth.valueOf(this.imonth);
    }

    public int getDayOfMonth() {
        return this.idom;
    }

    public Weekday getDayOfWeek() {
        long l = CALSYS.transform(this);
        return Weekday.valueOf(MathUtils.floorModulo(l + 5L, 7) + 1);
    }

    public int getDayOfYear() {
        return (Integer)this.get(DAY_OF_YEAR);
    }

    public int lengthOfMonth() {
        return CALSYS.getLengthOfMonth(IndianEra.SAKA, this.iyear, this.imonth);
    }

    public int lengthOfYear() {
        return this.isLeapYear() ? 366 : 365;
    }

    public boolean isLeapYear() {
        return GregorianMath.isLeapYear(this.iyear + 78);
    }

    public static boolean isValid(int n, int n2, int n3) {
        return CALSYS.isValid(IndianEra.SAKA, n, n2, n3);
    }

    public GeneralTimestamp<IndianCalendar> at(PlainTime plainTime) {
        return GeneralTimestamp.of(this, plainTime);
    }

    public GeneralTimestamp<IndianCalendar> atTime(int n, int n2) {
        return this.at(PlainTime.of(n, n2));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof IndianCalendar) {
            IndianCalendar indianCalendar = (IndianCalendar)object;
            return this.idom == indianCalendar.idom && this.imonth == indianCalendar.imonth && this.iyear == indianCalendar.iyear;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 17 * this.idom + 31 * this.imonth + 37 * this.iyear;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("Saka-");
        String string = String.valueOf(this.iyear);
        for (int i = string.length(); i < 4; ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        stringBuilder.append('-');
        if (this.imonth < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.imonth);
        stringBuilder.append('-');
        if (this.idom < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.idom);
        return stringBuilder.toString();
    }

    public static Weekmodel getDefaultWeekmodel() {
        return Weekmodel.of(Weekday.SUNDAY, 1, Weekday.SUNDAY, Weekday.SUNDAY);
    }

    public static TimeAxis<Unit, IndianCalendar> axis() {
        return ENGINE;
    }

    @Override
    protected TimeAxis<Unit, IndianCalendar> getChronology() {
        return ENGINE;
    }

    @Override
    protected IndianCalendar getContext() {
        return this;
    }

    private Object writeReplace() {
        return new SPX(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        Chronology.Builder builder = ((TimeAxis.Builder)((TimeAxis.Builder)((TimeAxis.Builder)TimeAxis.Builder.setUp(Unit.class, IndianCalendar.class, new Merger(), CALSYS).appendElement((ChronoElement)ERA, (ElementRule)new EraRule())).appendElement(YEAR_OF_ERA, new IntegerRule(0), Unit.YEARS).appendElement(MONTH_OF_YEAR, new MonthRule(), Unit.MONTHS).appendElement(DAY_OF_MONTH, new IntegerRule(2), Unit.DAYS).appendElement(DAY_OF_YEAR, new IntegerRule(3), Unit.DAYS).appendElement(DAY_OF_WEEK, new WeekdayRule<IndianCalendar>(IndianCalendar.getDefaultWeekmodel(), new ChronoFunction<IndianCalendar, CalendarSystem<IndianCalendar>>(){

            @Override
            public CalendarSystem<IndianCalendar> apply(IndianCalendar indianCalendar) {
                return CALSYS;
            }
        }), Unit.DAYS).appendElement(WIM_ELEMENT, WeekdayInMonthElement.getRule(WIM_ELEMENT))).appendElement((ChronoElement)CommonElements.RELATED_GREGORIAN_YEAR, new RelatedGregorianYearRule<IndianCalendar>(CALSYS, DAY_OF_YEAR))).appendUnit(Unit.YEARS, new IndianUnitRule(Unit.YEARS), Unit.YEARS.getLength(), Collections.singleton(Unit.MONTHS)).appendUnit(Unit.MONTHS, new IndianUnitRule(Unit.MONTHS), Unit.MONTHS.getLength(), Collections.singleton(Unit.YEARS)).appendUnit(Unit.WEEKS, new IndianUnitRule(Unit.WEEKS), Unit.WEEKS.getLength(), Collections.singleton(Unit.DAYS)).appendUnit(Unit.DAYS, new IndianUnitRule(Unit.DAYS), Unit.DAYS.getLength(), Collections.singleton(Unit.WEEKS)).appendExtension(new CommonElements.Weekengine(IndianCalendar.class, DAY_OF_MONTH, DAY_OF_YEAR, IndianCalendar.getDefaultWeekmodel()));
        ENGINE = ((TimeAxis.Builder)builder).build();
    }

    private static class SPX
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private static final int INDIAN = 10;
        private transient Object obj;

        public SPX() {
        }

        SPX(Object object) {
            this.obj = object;
        }

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeByte(10);
            this.writeIndian(objectOutput);
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws IOException {
            byte by = objectInput.readByte();
            switch (by) {
                case 10: {
                    this.obj = this.readIndian(objectInput);
                    break;
                }
                default: {
                    throw new InvalidObjectException("Unknown calendar type.");
                }
            }
        }

        private Object readResolve() throws ObjectStreamException {
            return this.obj;
        }

        private void writeIndian(ObjectOutput objectOutput) throws IOException {
            IndianCalendar indianCalendar = (IndianCalendar)this.obj;
            objectOutput.writeInt(indianCalendar.getYear());
            objectOutput.writeByte(indianCalendar.getMonth().getValue());
            objectOutput.writeByte(indianCalendar.getDayOfMonth());
        }

        private IndianCalendar readIndian(ObjectInput objectInput) throws IOException {
            int n = objectInput.readInt();
            byte by = objectInput.readByte();
            byte by2 = objectInput.readByte();
            return IndianCalendar.of(n, by, (int)by2);
        }
    }

    private static class IndianUnitRule
    implements UnitRule<IndianCalendar> {
        private final Unit unit;

        IndianUnitRule(Unit unit) {
            this.unit = unit;
        }

        @Override
        public IndianCalendar addTo(IndianCalendar indianCalendar, long l) {
            switch (this.unit) {
                case YEARS: {
                    l = MathUtils.safeMultiply(l, 12L);
                }
                case MONTHS: {
                    long l2 = MathUtils.safeAdd((long)IndianUnitRule.ymValue(indianCalendar), l);
                    int n = MathUtils.safeCast(MathUtils.floorDivide(l2, 12));
                    int n2 = MathUtils.floorModulo(l2, 12) + 1;
                    int n3 = Math.min(indianCalendar.idom, CALSYS.getLengthOfMonth(IndianEra.SAKA, n, n2));
                    return IndianCalendar.of(n, n2, n3);
                }
                case WEEKS: {
                    l = MathUtils.safeMultiply(l, 7L);
                }
                case DAYS: {
                    long l3 = MathUtils.safeAdd(CALSYS.transform(indianCalendar), l);
                    return (IndianCalendar)CALSYS.transform(l3);
                }
            }
            throw new UnsupportedOperationException(this.unit.name());
        }

        @Override
        public long between(IndianCalendar indianCalendar, IndianCalendar indianCalendar2) {
            switch (this.unit) {
                case YEARS: {
                    return Unit.MONTHS.between(indianCalendar, indianCalendar2) / 12L;
                }
                case MONTHS: {
                    long l = IndianUnitRule.ymValue(indianCalendar2) - IndianUnitRule.ymValue(indianCalendar);
                    if (l > 0L && indianCalendar2.idom < indianCalendar.idom) {
                        --l;
                    } else if (l < 0L && indianCalendar2.idom > indianCalendar.idom) {
                        ++l;
                    }
                    return l;
                }
                case WEEKS: {
                    return Unit.DAYS.between(indianCalendar, indianCalendar2) / 7L;
                }
                case DAYS: {
                    return CALSYS.transform(indianCalendar2) - CALSYS.transform(indianCalendar);
                }
            }
            throw new UnsupportedOperationException(this.unit.name());
        }

        private static int ymValue(IndianCalendar indianCalendar) {
            return indianCalendar.iyear * 12 + indianCalendar.imonth - 1;
        }
    }

    private static class Merger
    implements ChronoMerger<IndianCalendar> {
        private Merger() {
        }

        @Override
        public String getFormatPattern(DisplayStyle displayStyle, Locale locale) {
            return GenericDatePatterns.get("indian", displayStyle, locale);
        }

        @Override
        public IndianCalendar createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            TZID tZID;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                tZID = attributeQuery.get(Attributes.TIMEZONE_ID);
            } else if (attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax()) {
                tZID = Timezone.ofSystem().getID();
            } else {
                return null;
            }
            StartOfDay startOfDay = attributeQuery.get(Attributes.START_OF_DAY, this.getDefaultStartOfDay());
            return (IndianCalendar)Moment.from(timeSource.currentTime()).toGeneralTimestamp(ENGINE, tZID, startOfDay).toDate();
        }

        @Override
        public IndianCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            int n = chronoEntity.getInt(YEAR_OF_ERA);
            if (n == Integer.MIN_VALUE) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing Indian year.");
                return null;
            }
            if (chronoEntity.contains(MONTH_OF_YEAR)) {
                int n2 = ((IndianMonth)chronoEntity.get(MONTH_OF_YEAR)).getValue();
                int n3 = chronoEntity.getInt(DAY_OF_MONTH);
                if (n3 != Integer.MIN_VALUE) {
                    if (CALSYS.isValid(IndianEra.SAKA, n, n2, n3)) {
                        return IndianCalendar.of(n, n2, n3);
                    }
                    chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Indian date.");
                }
            } else {
                int n4 = chronoEntity.getInt(DAY_OF_YEAR);
                if (n4 != Integer.MIN_VALUE) {
                    if (n4 > 0) {
                        int n5 = 1;
                        int n6 = 0;
                        while (n5 <= 12) {
                            int n7 = CALSYS.getLengthOfMonth(IndianEra.SAKA, n, n5);
                            if (n4 > n6 + n7) {
                                ++n5;
                                n6 += n7;
                                continue;
                            }
                            return IndianCalendar.of(n, n5, n4 - n6);
                        }
                    }
                    chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Indian date.");
                }
            }
            return null;
        }

        @Override
        public ChronoDisplay preformat(IndianCalendar indianCalendar, AttributeQuery attributeQuery) {
            return indianCalendar;
        }

        @Override
        public Chronology<?> preparser() {
            return null;
        }

        @Override
        public StartOfDay getDefaultStartOfDay() {
            return StartOfDay.MIDNIGHT;
        }

        @Override
        public int getDefaultPivotYear() {
            return PlainDate.axis().getDefaultPivotYear() - 78;
        }
    }

    private static class EraRule
    implements ElementRule<IndianCalendar, IndianEra> {
        private EraRule() {
        }

        @Override
        public IndianEra getValue(IndianCalendar indianCalendar) {
            return IndianEra.SAKA;
        }

        @Override
        public IndianEra getMinimum(IndianCalendar indianCalendar) {
            return IndianEra.SAKA;
        }

        @Override
        public IndianEra getMaximum(IndianCalendar indianCalendar) {
            return IndianEra.SAKA;
        }

        @Override
        public boolean isValid(IndianCalendar indianCalendar, IndianEra indianEra) {
            return indianEra != null;
        }

        @Override
        public IndianCalendar withValue(IndianCalendar indianCalendar, IndianEra indianEra, boolean bl) {
            if (indianEra == null) {
                throw new IllegalArgumentException("Missing era value.");
            }
            return indianCalendar;
        }

        @Override
        public ChronoElement<?> getChildAtFloor(IndianCalendar indianCalendar) {
            return YEAR_OF_ERA;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(IndianCalendar indianCalendar) {
            return YEAR_OF_ERA;
        }
    }

    private static class MonthRule
    implements ElementRule<IndianCalendar, IndianMonth> {
        private MonthRule() {
        }

        @Override
        public IndianMonth getValue(IndianCalendar indianCalendar) {
            return indianCalendar.getMonth();
        }

        @Override
        public IndianMonth getMinimum(IndianCalendar indianCalendar) {
            return IndianMonth.CHAITRA;
        }

        @Override
        public IndianMonth getMaximum(IndianCalendar indianCalendar) {
            return IndianMonth.PHALGUNA;
        }

        @Override
        public boolean isValid(IndianCalendar indianCalendar, IndianMonth indianMonth) {
            return indianMonth != null;
        }

        @Override
        public IndianCalendar withValue(IndianCalendar indianCalendar, IndianMonth indianMonth, boolean bl) {
            if (indianMonth == null) {
                throw new IllegalArgumentException("Missing month.");
            }
            int n = indianMonth.getValue();
            int n2 = CALSYS.getLengthOfMonth(IndianEra.SAKA, indianCalendar.iyear, n);
            int n3 = Math.min(indianCalendar.idom, n2);
            return new IndianCalendar(indianCalendar.iyear, n, n3);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(IndianCalendar indianCalendar) {
            return DAY_OF_MONTH;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(IndianCalendar indianCalendar) {
            return DAY_OF_MONTH;
        }
    }

    private static class IntegerRule
    implements IntElementRule<IndianCalendar> {
        private final int index;

        IntegerRule(int n) {
            this.index = n;
        }

        @Override
        public int getInt(IndianCalendar indianCalendar) {
            switch (this.index) {
                case 0: {
                    return indianCalendar.iyear;
                }
                case 2: {
                    return indianCalendar.idom;
                }
                case 3: {
                    int n = 0;
                    for (int i = 1; i < indianCalendar.imonth; ++i) {
                        n += CALSYS.getLengthOfMonth(IndianEra.SAKA, indianCalendar.iyear, i);
                    }
                    return n + indianCalendar.idom;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public boolean isValid(IndianCalendar indianCalendar, int n) {
            int n2 = this.getMin();
            int n3 = this.getMax(indianCalendar);
            return n2 <= n && n3 >= n;
        }

        @Override
        public IndianCalendar withValue(IndianCalendar indianCalendar, int n, boolean bl) {
            if (!this.isValid(indianCalendar, n)) {
                throw new IllegalArgumentException("Out of range: " + n);
            }
            switch (this.index) {
                case 0: {
                    int n2 = CALSYS.getLengthOfMonth(IndianEra.SAKA, n, indianCalendar.imonth);
                    int n3 = Math.min(indianCalendar.idom, n2);
                    return new IndianCalendar(n, indianCalendar.imonth, n3);
                }
                case 2: {
                    return new IndianCalendar(indianCalendar.iyear, indianCalendar.imonth, n);
                }
                case 3: {
                    int n4 = n - this.getValue(indianCalendar);
                    return (IndianCalendar)indianCalendar.plus(CalendarDays.of(n4));
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public Integer getValue(IndianCalendar indianCalendar) {
            return this.getInt(indianCalendar);
        }

        @Override
        public Integer getMinimum(IndianCalendar indianCalendar) {
            return this.getMin();
        }

        @Override
        public Integer getMaximum(IndianCalendar indianCalendar) {
            return this.getMax(indianCalendar);
        }

        @Override
        public boolean isValid(IndianCalendar indianCalendar, Integer n) {
            return n != null && this.isValid(indianCalendar, (int)n);
        }

        @Override
        public IndianCalendar withValue(IndianCalendar indianCalendar, Integer n, boolean bl) {
            if (n == null) {
                throw new IllegalArgumentException("Missing new value.");
            }
            return this.withValue(indianCalendar, (int)n, bl);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(IndianCalendar indianCalendar) {
            if (this.index == 0) {
                return MONTH_OF_YEAR;
            }
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(IndianCalendar indianCalendar) {
            if (this.index == 0) {
                return MONTH_OF_YEAR;
            }
            return null;
        }

        private int getMin() {
            switch (this.index) {
                case 0: 
                case 2: 
                case 3: {
                    return 1;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        private int getMax(IndianCalendar indianCalendar) {
            switch (this.index) {
                case 0: {
                    return 999999921;
                }
                case 2: {
                    return CALSYS.getLengthOfMonth(IndianEra.SAKA, indianCalendar.iyear, indianCalendar.imonth);
                }
                case 3: {
                    return CALSYS.getLengthOfYear(IndianEra.SAKA, indianCalendar.iyear);
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }
    }

    private static class Transformer
    implements EraYearMonthDaySystem<IndianCalendar> {
        private Transformer() {
        }

        @Override
        public boolean isValid(CalendarEra calendarEra, int n, int n2, int n3) {
            return calendarEra == IndianEra.SAKA && n >= 1 && n <= 999999921 && n2 >= 1 && n2 <= (n == 999999921 ? 10 : 12) && n3 >= 1 && n3 <= this.getLengthOfMonth(calendarEra, n, n2);
        }

        @Override
        public int getLengthOfMonth(CalendarEra calendarEra, int n, int n2) {
            if (calendarEra != IndianEra.SAKA) {
                throw new IllegalArgumentException("Invalid era: " + calendarEra);
            }
            if (n >= 1 && n <= 999999921 && n2 >= 1) {
                if (n == 999999921 && n2 == 10) {
                    return 10;
                }
                if (n2 == 1) {
                    return GregorianMath.isLeapYear(n + 78) ? 31 : 30;
                }
                if (n2 <= 6) {
                    return 31;
                }
                if (n2 <= 12) {
                    return 30;
                }
            }
            throw new IllegalArgumentException("Out of bounds: year=" + n + ", month=" + n2);
        }

        @Override
        public int getLengthOfYear(CalendarEra calendarEra, int n) {
            if (calendarEra != IndianEra.SAKA) {
                throw new IllegalArgumentException("Invalid era: " + calendarEra);
            }
            if (n >= 1 && n < 999999921) {
                return GregorianMath.isLeapYear(n + 78) ? 366 : 365;
            }
            if (n == 999999921) {
                return 285;
            }
            throw new IllegalArgumentException("Out of bounds: year=" + n);
        }

        @Override
        public IndianCalendar transform(long l) {
            int n;
            int n2;
            PlainDate plainDate = PlainDate.of(l, EpochDays.UTC);
            int n3 = plainDate.getYear();
            int n4 = plainDate.getMonth();
            int n5 = plainDate.getDayOfMonth();
            boolean bl = GregorianMath.isLeapYear(n3);
            int n6 = bl ? 21 : 22;
            int n7 = plainDate.getYear() - 78;
            if (n4 == 12 && n5 >= 22) {
                n2 = 10;
                n = n5 - 21;
            } else if (n4 == 12) {
                n2 = 9;
                n = n5 + 9;
            } else if (n4 == 11 && n5 >= 22) {
                n2 = 9;
                n = n5 - 21;
            } else if (n4 == 11) {
                n2 = 8;
                n = n5 + 9;
            } else if (n4 == 10 && n5 >= 23) {
                n2 = 8;
                n = n5 - 22;
            } else if (n4 == 10) {
                n2 = 7;
                n = n5 + 8;
            } else if (n4 == 9 && n5 >= 23) {
                n2 = 7;
                n = n5 - 22;
            } else if (n4 == 9) {
                n2 = 6;
                n = n5 + 9;
            } else if (n4 == 8 && n5 >= 23) {
                n2 = 6;
                n = n5 - 22;
            } else if (n4 == 8) {
                n2 = 5;
                n = n5 + 9;
            } else if (n4 == 7 && n5 >= 23) {
                n2 = 5;
                n = n5 - 22;
            } else if (n4 == 7) {
                n2 = 4;
                n = n5 + 9;
            } else if (n4 == 6 && n5 >= 22) {
                n2 = 4;
                n = n5 - 21;
            } else if (n4 == 6) {
                n2 = 3;
                n = n5 + 10;
            } else if (n4 == 5 && n5 >= 22) {
                n2 = 3;
                n = n5 - 21;
            } else if (n4 == 5) {
                n2 = 2;
                n = n5 + 10;
            } else if (n4 == 4 && n5 >= 21) {
                n2 = 2;
                n = n5 - 20;
            } else if (n4 == 4) {
                n2 = 1;
                n = n5 + (bl ? 11 : 10);
            } else if (n4 == 3 && n5 >= n6) {
                n2 = 1;
                n = n5 - n6 + 1;
            } else if (n4 == 3) {
                --n7;
                n2 = 12;
                n = n5 + (bl ? 10 : 9);
            } else if (n4 == 2 && n5 >= 20) {
                --n7;
                n2 = 12;
                n = n5 - 19;
            } else if (n4 == 2) {
                --n7;
                n2 = 11;
                n = n5 + 11;
            } else if (n4 == 1 && n5 >= 21) {
                --n7;
                n2 = 11;
                n = n5 - 20;
            } else {
                --n7;
                n2 = 10;
                n = n5 + 10;
            }
            return IndianCalendar.of(n7, n2, n);
        }

        @Override
        public long transform(IndianCalendar indianCalendar) {
            int n;
            boolean bl = GregorianMath.isLeapYear(n = indianCalendar.iyear + 78);
            long l = PlainDate.of(n, 3, bl ? 21 : 22).get(EpochDays.UTC);
            int n2 = 0;
            block4: for (int i = 1; i < indianCalendar.imonth; ++i) {
                switch (i) {
                    case 1: {
                        n2 += bl ? 31 : 30;
                        continue block4;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        n2 += 31;
                        continue block4;
                    }
                    default: {
                        n2 += 30;
                    }
                }
            }
            return l + (long)(n2 += indianCalendar.idom - 1);
        }

        @Override
        public long getMinimumSinceUTC() {
            IndianCalendar indianCalendar = new IndianCalendar(1, 1, 1);
            return this.transform(indianCalendar);
        }

        @Override
        public long getMaximumSinceUTC() {
            IndianCalendar indianCalendar = new IndianCalendar(999999921, 10, 10);
            return this.transform(indianCalendar);
        }

        @Override
        public List<CalendarEra> getEras() {
            IndianEra indianEra = IndianEra.SAKA;
            return Collections.singletonList(indianEra);
        }
    }

    public static enum Unit implements ChronoUnit
    {
        YEARS(3.1556952E7),
        MONTHS(2629746.0),
        WEEKS(604800.0),
        DAYS(86400.0);

        private final transient double length;

        private Unit(double d) {
            this.length = d;
        }

        @Override
        public double getLength() {
            return this.length;
        }

        @Override
        public boolean isCalendrical() {
            return true;
        }

        public long between(IndianCalendar indianCalendar, IndianCalendar indianCalendar2) {
            return indianCalendar.until(indianCalendar2, this);
        }
    }
}

