/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.base.ResourceLoader;
import net.time4j.i18n.LanguageMatch;
import net.time4j.i18n.UTF8ResourceReader;

public final class PropertyBundle {
    private static final ConcurrentMap<CacheKey, BundleReference> CACHE = new ConcurrentHashMap<CacheKey, BundleReference>(32);
    private static final ReferenceQueue<Object> REFERENCE_QUEUE = new ReferenceQueue();
    private final PropertyBundle parent;
    private final Map<String, String> key2values;
    private final String baseName;
    private final Locale bundleLocale;

    private PropertyBundle(UTF8ResourceReader uTF8ResourceReader, String string, Locale locale) throws IOException {
        String string2;
        this.parent = null;
        this.baseName = string;
        this.bundleLocale = locale;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        block0: while ((string2 = uTF8ResourceReader.readLine()) != null) {
            if ((string2 = string2.trim()).isEmpty() || string2.charAt(0) == '#') continue;
            int n = string2.length();
            for (int i = 0; i < n; ++i) {
                char c = string2.charAt(i);
                if (c != '=' || i + 1 >= n) continue;
                hashMap.put(string2.substring(0, i), string2.substring(i + 1));
                continue block0;
            }
        }
        this.key2values = Collections.unmodifiableMap(hashMap);
    }

    private PropertyBundle(PropertyBundle propertyBundle, PropertyBundle propertyBundle2) {
        this.parent = propertyBundle2;
        this.baseName = propertyBundle.baseName;
        this.bundleLocale = propertyBundle.bundleLocale;
        this.key2values = propertyBundle.key2values;
    }

    public static PropertyBundle load(String string, Locale locale) {
        Reference<Object> reference;
        PropertyBundle propertyBundle;
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Base name must not be empty.");
        }
        if (locale == null) {
            throw new NullPointerException("Missing locale.");
        }
        CacheKey cacheKey = new CacheKey(string, locale);
        BundleReference bundleReference = (BundleReference)CACHE.get(cacheKey);
        if (bundleReference != null) {
            propertyBundle = (PropertyBundle)bundleReference.get();
            bundleReference = null;
            if (propertyBundle != null) {
                return propertyBundle;
            }
        }
        while ((reference = REFERENCE_QUEUE.poll()) != null) {
            CACHE.remove(((BundleReference)reference).cacheKey);
        }
        ArrayList<PropertyBundle> arrayList = new ArrayList<PropertyBundle>();
        for (Locale locale2 : PropertyBundle.getCandidateLocales(locale)) {
            try {
                propertyBundle = PropertyBundle.newBundle(string, locale2);
                if (propertyBundle == null) continue;
                arrayList.add(propertyBundle);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
        if (arrayList.isEmpty()) {
            throw new MissingResourceException("Cannot find resource bundle for: " + PropertyBundle.toResourceName(string, locale), PropertyBundle.class.getName(), "");
        }
        for (int i = arrayList.size() - 1; i >= 1; --i) {
            arrayList.set(i - 1, ((PropertyBundle)arrayList.get(i - 1)).withParent((PropertyBundle)arrayList.get(i)));
        }
        propertyBundle = (PropertyBundle)arrayList.get(0);
        CACHE.putIfAbsent(cacheKey, new BundleReference(propertyBundle, cacheKey));
        return propertyBundle;
    }

    public String getString(String string) {
        if (string == null) {
            throw new NullPointerException("Missing resource key.");
        }
        PropertyBundle propertyBundle = this;
        do {
            String string2;
            if ((string2 = propertyBundle.key2values.get(string)) == null) continue;
            return string2;
        } while ((propertyBundle = propertyBundle.parent) != null);
        throw new MissingResourceException("Cannot find property resource for: " + PropertyBundle.toResourceName(this.baseName, this.bundleLocale) + "=>" + string, PropertyBundle.class.getName(), string);
    }

    public boolean containsKey(String string) {
        if (string == null) {
            throw new NullPointerException("Missing resource key.");
        }
        PropertyBundle propertyBundle = this;
        do {
            String string2;
            if ((string2 = propertyBundle.key2values.get(string)) == null) continue;
            return true;
        } while ((propertyBundle = propertyBundle.parent) != null);
        return false;
    }

    public Set<String> keySet() {
        PropertyBundle propertyBundle = this;
        HashSet<String> hashSet = new HashSet<String>(propertyBundle.key2values.keySet());
        while ((propertyBundle = propertyBundle.parent) != null) {
            hashSet.addAll(propertyBundle.key2values.keySet());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public Locale getLocale() {
        return this.bundleLocale;
    }

    public static void clearCache() {
        while (REFERENCE_QUEUE.poll() != null) {
        }
        CACHE.clear();
    }

    public Set<String> getInternalKeys() {
        return this.key2values.keySet();
    }

    public static List<Locale> getCandidateLocales(Locale locale) {
        String string = LanguageMatch.getAlias(locale);
        String string2 = locale.getCountry();
        String string3 = locale.getVariant();
        LinkedList<Locale> linkedList = new LinkedList<Locale>();
        if (!string3.isEmpty()) {
            linkedList.add(new Locale(string, string2, string3));
        }
        if (!string2.isEmpty()) {
            linkedList.add(new Locale(string, string2, ""));
        }
        if (!string.isEmpty()) {
            linkedList.add(new Locale(string, "", ""));
            if (string.equals("nn")) {
                linkedList.add(new Locale("nb", "", ""));
            }
        }
        linkedList.add(Locale.ROOT);
        return linkedList;
    }

    private PropertyBundle withParent(PropertyBundle propertyBundle) {
        if (propertyBundle == null) {
            return this;
        }
        return new PropertyBundle(this, propertyBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PropertyBundle newBundle(String string, Locale locale) throws IOException {
        PropertyBundle propertyBundle = null;
        int n = string.indexOf(47);
        String string2 = string.substring(0, n);
        String string3 = PropertyBundle.toResourceName(string.substring(n + 1), locale);
        URI uRI = ResourceLoader.getInstance().locate(string2, PropertyBundle.class, string3);
        InputStream inputStream = ResourceLoader.getInstance().load(uRI, true);
        if (inputStream == null) {
            try {
                inputStream = ResourceLoader.getInstance().load(PropertyBundle.class, string3, true);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (inputStream != null) {
            UTF8ResourceReader uTF8ResourceReader = null;
            try {
                uTF8ResourceReader = new UTF8ResourceReader(inputStream);
                propertyBundle = new PropertyBundle(uTF8ResourceReader, string, locale);
            }
            finally {
                if (uTF8ResourceReader != null) {
                    uTF8ResourceReader.close();
                }
            }
        }
        return propertyBundle;
    }

    private static String toResourceName(String string, Locale locale) {
        String string2 = LanguageMatch.getAlias(locale);
        String string3 = locale.getCountry();
        String string4 = locale.getVariant();
        StringBuilder stringBuilder = new StringBuilder(string.length() + 20);
        stringBuilder.append(string.replace('.', '/'));
        if (!string2.isEmpty()) {
            stringBuilder.append('_').append(string2);
            if (!string4.isEmpty()) {
                stringBuilder.append('_').append(string3).append('_').append(string4);
            } else if (!string3.isEmpty()) {
                stringBuilder.append('_').append(string3);
            }
        }
        return stringBuilder.append(".properties").toString();
    }

    private static class BundleReference
    extends SoftReference<PropertyBundle> {
        private CacheKey cacheKey;

        BundleReference(PropertyBundle propertyBundle, CacheKey cacheKey) {
            super(propertyBundle, REFERENCE_QUEUE);
            this.cacheKey = cacheKey;
        }
    }

    private static class CacheKey {
        private final String baseName;
        private final Locale locale;

        CacheKey(String string, Locale locale) {
            this.baseName = string;
            this.locale = locale;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof CacheKey) {
                CacheKey cacheKey = (CacheKey)object;
                return this.baseName.equals(cacheKey.baseName) && this.locale.equals(cacheKey.locale);
            }
            return false;
        }

        public int hashCode() {
            int n = this.baseName.hashCode() << 3;
            return n ^= this.locale.hashCode();
        }

        public String toString() {
            return this.baseName + "/" + this.locale;
        }
    }
}

