/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.time4j.Moment;
import net.time4j.base.GregorianDate;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.base.WallTime;
import net.time4j.engine.EpochDays;
import net.time4j.scale.TimeScale;
import net.time4j.tz.TransitionHistory;
import net.time4j.tz.ZonalOffset;
import net.time4j.tz.ZonalTransition;
import net.time4j.tz.model.ArrayTransitionModel;
import net.time4j.tz.model.CompositeTransitionModel;
import net.time4j.tz.model.DaylightSavingRule;
import net.time4j.tz.model.EmptyTransitionModel;
import net.time4j.tz.model.RuleBasedTransitionModel;
import net.time4j.tz.model.RuleComparator;

public abstract class TransitionModel
implements TransitionHistory,
Serializable {
    static final String NEW_LINE = System.getProperty("line.separator");

    TransitionModel() {
    }

    public static TransitionHistory of(List<ZonalTransition> list) {
        return new ArrayTransitionModel(list);
    }

    public static TransitionHistory of(ZonalOffset zonalOffset, List<DaylightSavingRule> list) {
        if (list.isEmpty()) {
            return new EmptyTransitionModel(zonalOffset);
        }
        return new RuleBasedTransitionModel(zonalOffset, list);
    }

    public static TransitionHistory of(ZonalOffset zonalOffset, List<ZonalTransition> list, List<DaylightSavingRule> list2) {
        return TransitionModel.of(zonalOffset, list, list2, true, true);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean hasNegativeDST() {
        return false;
    }

    static TransitionHistory of(ZonalOffset zonalOffset, List<ZonalTransition> list, List<DaylightSavingRule> list2, boolean bl, boolean bl2) {
        long l;
        List<DaylightSavingRule> list3;
        List<ZonalTransition> list4;
        if (bl) {
            list4 = new ArrayList<ZonalTransition>(list);
            list3 = new ArrayList<DaylightSavingRule>(list2);
            Collections.sort(list4);
            Collections.sort(list3, RuleComparator.INSTANCE);
        } else {
            list4 = list;
            list3 = list2;
        }
        int n = list4.size();
        if (n == 0) {
            if (list3.isEmpty()) {
                return new EmptyTransitionModel(zonalOffset);
            }
            return new RuleBasedTransitionModel(zonalOffset, list3, false);
        }
        ZonalOffset zonalOffset2 = ZonalOffset.ofTotalSeconds(list4.get(0).getPreviousOffset());
        if (bl2 && !zonalOffset.equals(zonalOffset2)) {
            throw new IllegalArgumentException("Initial offset " + zonalOffset + " not equal " + "to previous offset of first transition: " + zonalOffset2);
        }
        if (list3.isEmpty()) {
            return new ArrayTransitionModel(list4, false, bl2);
        }
        ZonalTransition zonalTransition = list4.get(n - 1);
        long l2 = zonalTransition.getPosixTime() + 1L;
        if (l2 < (l = TransitionModel.getFutureMoment(1))) {
            list4.addAll(RuleBasedTransitionModel.getTransitions(zonalTransition, list3, l2, l));
        }
        return new CompositeTransitionModel(n, list4, list3, false, bl2);
    }

    static List<ZonalOffset> toList(int n) {
        return Collections.singletonList(ZonalOffset.ofTotalSeconds(n));
    }

    static List<ZonalOffset> toList(int n, int n2) {
        ZonalOffset zonalOffset = ZonalOffset.ofTotalSeconds(n);
        ZonalOffset zonalOffset2 = ZonalOffset.ofTotalSeconds(n2);
        ArrayList<ZonalOffset> arrayList = new ArrayList<ZonalOffset>(2);
        arrayList.add(zonalOffset);
        arrayList.add(zonalOffset2);
        return Collections.unmodifiableList(arrayList);
    }

    static long toLocalSecs(GregorianDate gregorianDate, WallTime wallTime) {
        long l = GregorianMath.toMJD(gregorianDate.getYear(), gregorianDate.getMonth(), gregorianDate.getDayOfMonth());
        long l2 = MathUtils.safeMultiply(EpochDays.UNIX.transform(l, EpochDays.MODIFIED_JULIAN_DATE), 86400L);
        l2 += (long)(wallTime.getHour() * 3600);
        l2 += (long)(wallTime.getMinute() * 60);
        return l2 += (long)wallTime.getSecond();
    }

    static void dump(ZonalTransition zonalTransition, Appendable appendable) throws IOException {
        Moment moment = Moment.of(zonalTransition.getPosixTime(), TimeScale.POSIX);
        appendable.append(">>> Transition at: ").append(moment.toString());
        appendable.append(" from ").append(TransitionModel.format(zonalTransition.getPreviousOffset()));
        appendable.append(" to ").append(TransitionModel.format(zonalTransition.getTotalOffset()));
        appendable.append(", DST=");
        appendable.append(TransitionModel.format(zonalTransition.getDaylightSavingOffset()));
        appendable.append(NEW_LINE);
    }

    static long getFutureMoment(int n) {
        long l = (long)(3.1556952E7 * (double)n);
        return System.currentTimeMillis() / 1000L + l;
    }

    private static String format(int n) {
        return ZonalOffset.ofTotalSeconds(n).toString();
    }
}

